<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Controllers;

use App\Http\Controllers\Controller;
use Theme, File, Response;

class AssetController extends Controller
{
    public function backend($path = null)
    {
        $backend        = Theme::getBackend();
        $fullPath       = base_path("Themes/backend/".$backend."/assets/".$path);
        $extension      = File::extension($fullPath);
        $content        = File::get($fullPath);
        $contentType    = config("mimetypes.mimes.$extension.0");

        return response($content, 200)
              ->header('Content-Type', $contentType)
              ->header('Cache-control', 'public');
    }

    public function frontend($path = null)
    {
        $frontend       = Theme::getFrontend();
        $fullPath       = base_path("Themes/frontend/".$frontend."/assets/".$path);
        $extension      = File::extension($fullPath);
        $content        = File::get($fullPath);
        $contentType    = config("mimetypes.mimes.$extension.0");

        return response($content, 200)
              ->header('Content-Type', $contentType)
              ->header('Cache-control', 'public');
    }

}
