<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\File;
use Blade;

class AclServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerBlade();
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->registerBindings();
    }

    /**
     * Register service provider bindings
     */
    public function registerBindings()
    {
        $this->app->bind(
            \Modules\Iauth\Repositories\Access\User\UserRepositoryContract::class,
            \Modules\Iauth\Repositories\Access\User\EloquentUserRepository::class
        );

        $this->app->bind(
            \Modules\Iauth\Repositories\Access\Role\RoleRepositoryContract::class,
            \Modules\Iauth\Repositories\Access\Role\EloquentRoleRepository::class
        );

        $this->app->bind(
            \Modules\Iauth\Repositories\Access\Permission\PermissionRepositoryContract::class,
            \Modules\Iauth\Repositories\Access\Permission\EloquentPermissionRepository::class
        );

        $this->app->bind(
            \Modules\Iauth\Repositories\Access\Permission\PermissionAssignRepositoryContract::class,
            \Modules\Iauth\Repositories\Access\Permission\EloquentPermissionAssignRepository::class
        );
    }

    /**
     * Register Blade Template Extensions for >= L5.1
     */
    protected function registerBlade()
    {
        // role
        Blade::directive('role', function ($expression) {
            return "<?php if (Auth::check() && Auth::user()->hasrole({$expression})): ?>";
        });

        Blade::directive('endrole', function () {
            return "<?php endif; ?>";
        });

        // notrole
        Blade::directive('notrole', function ($expression) {
            return "<?php if (Auth::check() && !Auth::user()->hasrole({$expression})): ?>";
        });

        Blade::directive('endnotrole', function () {
            return "<?php endif; ?>";
        });

        // roles
        Blade::directive('roles', function ($expression, $needAll = true) {
            return "<?php if (Auth::check() && Auth::user()->hasroles({$expression},{$needAll})): ?>";
        });

        Blade::directive('endroles', function () {
            return "<?php endif; ?>";
        });

        // permission
        Blade::directive('permission', function ($expression) {
            return "<?php if (Auth::check() && Auth::user()->hasPermission({$expression})): ?>";
        });

        Blade::directive('endpermission', function () {
            return "<?php endif; ?>";
        });

        // notpermission
        Blade::directive('notpermission', function ($expression) {
            return "<?php if (Auth::check() && !Auth::user()->hasPermission({$expression})): ?>";
        });

        Blade::directive('endnotpermission', function () {
            return "<?php endif; ?>";
        });

        // permissions
        Blade::directive('permissions', function ($expression, $needAll = true) {
            return "<?php if (Auth::check() && Auth::user()->hasPermissions({$expression}, {$needAll})): ?>";
        });

        Blade::directive('endpermissions', function () {
            return "<?php endif; ?>";
        });
    }
}
