<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        //
    ];

    /**
     * Class event subscribers
     * @var array
     */
    protected $subscribe = [
        /**
         * Backend Subscribers
         */
        \Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener::class,
        \Modules\Iauth\Listeners\Access\User\Mail\NewUserRegistered::class,
        \Modules\Iauth\Listeners\Access\Role\History\RoleEventListener::class,
        \Modules\Notice\Listeners\History\NoticeEventHistoryListener::class,
        \Modules\Todo\Listeners\History\TodoEventHistoryListener::class,
    ];
    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
