<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\File;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $module =  File::get(base_path('Core/src').'/Config/module.stub');

        if ( ! File::exists(base_path('config').'/module.php') ) {

            File::put( base_path('config').'/module.php', $module);

        }

        if(is_dir(base_path('Modules'))) {

            $modules = $this->getAllActiveModules();

            foreach ($modules as $module) {

                $routes     = base_path('Modules').'/'.$module.'/routes.php';
                $views      = base_path('Modules').'/'.$module.'/Views';
                $lang       = base_path('Modules').'/'.$module.'/Lang';
                $helper     = base_path('Modules').'/'.$module.'/helper.php';
                $migrations = base_path('Modules').'/'.$module.'/Migrations';

                if(file_exists($routes)) {
                    include $routes;
                }

                if(file_exists($helper)) {
                    include $helper;
                }

                if(is_dir($views)) {
                    $this->loadViewsFrom($views, $module);
                }

                if(is_dir($lang)) {
                    $this->loadTranslationsFrom($lang,$module);
                }

                if(is_dir($migrations)) {
                    $this->loadMigrationsFrom($migrations);
                }
            }

        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->commands(
            'command.make.module'
        );

        $this->app->singleton('command.make.module', function()
        {
            return new Console\Commands\ModuleCommand;
        });

        if(is_dir(base_path('Modules'))) {

            $modules = $this->getAllActiveModules();

            foreach ($modules as $module) {

                $providers       = base_path('Modules').'/'.$module.'/Providers';

                if(is_dir($providers)) {
                    foreach (glob($providers.'/*.php') as $filename){
                        $filename = basename($filename, '.php');
                        $class = '\Modules\\'.$module.'\\Providers\\'.$filename;
                        $this->app->register($class);
                    }
                }
            }

        }
    }

    public function getAllActiveModules()
    {
        $getAllModules = array_map('class_basename', File::directories(base_path('Modules')));
        $disableModules = config("module.disable");

        $modules = array_diff($getAllModules, $disableModules);

        return $modules;
    }
}
