<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core\Providers;

use Illuminate\Support\ServiceProvider;
use View, Theme, Cache, File, Config, App;

class ThemeServiceProvider extends ServiceProvider
{

    protected $backend; // for admin templates

    protected $frontend; // for all users templates

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $core =  File::get(base_path('Core/src').'/Config/core.stub');
        $mimetypes =  File::get(base_path('Core/src').'/Config/mimetypes.stub');

        if ( ! File::exists(base_path('config').'/core.php') ) {

            File::put( base_path('config').'/core.php', $core);

        }

        if ( ! File::exists(base_path('config').'/mimetypes.php') ) {

            File::put( base_path('config').'/mimetypes.php', $mimetypes);

        }

        $routes = base_path('Core/src/routes.php');

        if(file_exists($routes)) {
            include $routes;
        }

        if(env('APP_INSTALL')) {
            $this->backend = Theme::getBackend();
            $this->frontend = Theme::getFrontend();

            View::addLocation(base_path('Core/src/Theme'));
            View::addNamespace('ThemesRoot',base_path('Themes'));
            View::addNamespace('BackEndRoot',base_path('Themes/backend'));
            View::addNamespace('FrontendEndRoot',base_path('Themes/frontend'));
            View::addNamespace('backend', base_path('Themes/backend/'.$this->backend.'/views'));
            View::addNamespace('frontend', base_path('Themes/frontend/'.$this->frontend.'/views'));
        }
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->commands(
            'command.make.theme'
        );

        $this->app->singleton('command.make.theme', function()
        {
            return new Console\Commands\ThemeCommand;
        });

        $this->app->bind('theme', function()
        {
            return new \Core\Theme;
        });
    }

}
