<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Core;

use Config, File, Artisan, Cache, View;
use Illuminate\Pagination\Paginator;

class Theme
{
    protected $corePath;

    public function __construct()
    {
        $this->corePath = base_path('config/core.php');
    }

    public function getBackend()
    {
        if(!Cache::has('backendtheme')) {
            if($this->checkPermission($this->corePath)) {
                Cache::forever('backendtheme', Config::get('core.backendtheme'));
            } else {
                Cache::forever('backendtheme', isite()->getSiteBackendTheme());
            }
        }

        if(config('core.switch.enable.backend')) {
            return Cache::get('backendtheme');
        } else {
            return config('core.backendtheme');
        }
    }

    public function getFrontend()
    {
        if(!Cache::has('frontendtheme')) {
            if($this->checkPermission($this->corePath)) {
                Cache::forever('frontendtheme', Config::get('core.frontendtheme'));
            } else {
                Cache::forever('frontendtheme', isite()->getSiteFrontendTheme());
            }
        }

        if(config('core.switch.enable.frontend')) {
            return Cache::get('frontendtheme');
        } else {
            return config('core.frontendtheme');
        }
    }

    public function getHaveFrontend()
    {
        if($this->checkPermission($this->corePath)) {
            return Config::get('core.havefrontend');
        } else {
            return isite()->siteHaveFrontend() == 'yes' ? true : false;
        }
    }

    public function setBackend( $theme )
    {
        if(config('core.switch.enable.backend')) {
            if($this->checkPermission($this->corePath)) {
                File::put($this->corePath, str_replace(
                    "'backendtheme' => '".Config::get('core.backendtheme')."'",
                    "'backendtheme' => '".$theme."'",
                    File::get($this->corePath)
                ));
            }
        } else {
            $theme = config('core.backendtheme');
        }


        Config::set('core.backendtheme', $theme);
        Cache::forever('backendtheme', $theme);
    }

    public function setFrontend( $theme )
    {
        if(config('core.switch.enable.frontend')) {
            if ($this->checkPermission($this->corePath)) {
                File::put($this->corePath, str_replace(
                    "'frontendtheme' => '" . Config::get('core.frontendtheme') . "'",
                    "'frontendtheme' => '" . $theme . "'",
                    File::get($this->corePath)
                ));
            }
        } else {
            $theme = config('core.frontendtheme');
        }
//        dd($theme);

        Config::set('core.frontendtheme', $theme);
        Cache::forever('frontendtheme', $theme);
    }

    public function setHaveFrontend( $status )
    {
        if($this->checkPermission($this->corePath)) {
            if(Config::get('core.havefrontend')) {
                File::put($this->corePath, str_replace(
                    "'havefrontend' => true",
                    "'havefrontend' => false",
                    File::get($this->corePath)
                ));
            } else {
                File::put($this->corePath, str_replace(
                    "'havefrontend' => false",
                    "'havefrontend' => true",
                    File::get($this->corePath)
                ));
            }
        }

        Config::set('core.havefrontend', $status);
    }

    public function initBackend()
    {
        $this->setBackend('default');
    }

    public function initFrontend()
    {
        $this->setFrontend('default');
    }

    public function checkPermission()
    {
        $getPermission = substr(sprintf('%o', fileperms($this->corePath)), -4);
        if($getPermission >= 777) {
            return true;
        }

        return false;
    }

}
