@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Bank::bank.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Bank::bank.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('bank.list') }}"><i class="fa fa-laptop"></i>{{ trans('Bank::bank.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Bank::bank.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    {{--@roles([1])--}}
                    <a href="{{ route('bank.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Bank::bank.buttons.create') }}
                        </button>
                    </a>
                    {{--@endroles--}}
                    <table id="banks-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ trans('Bank::bank.columns.bank_title') }}</th>
                            <th>{{ trans('Bank::bank.columns.ini_balance') }}</th>
                            <th>{{ trans('Bank::bank.columns.current_balance') }}</th>
                            <th>{{ trans('Bank::bank.columns.holder_name') }}</th>
                            <th>{{ trans('Bank::bank.columns.account_no') }}</th>
                            <th>{{ trans('Bank::bank.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#banks-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("bank.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'bank_title', name: 'bank_title'},
                {data: 'ini_balance', name: 'ini_balance'},
                {data: 'balance', name: 'balance'},
                {data: 'holder_name', name: 'holder_name'},
                {data: 'account_no', name: 'account_no'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "asc"]],
            searchDelay: 500

        });

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush