<?php

namespace Modules\Client\Requests;

use App\Http\Requests\Request;

class ClientRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $user = $this->route('user'); // this is route parameter name


        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'username' => 'required|max:20|min:3|alpha_dash|unique:users,username',
                    'first_name' => 'max:30',
                    'last_name' => 'max:30',
                    'company' => 'max:20',
                    'phone' => 'max:20',
                    'address_line_one' => '',
                    'address_line_two' => '',
                    'city' => '',
                    'state' => '',
                    'zip_code' => '',
                    'country' => '',
                    'email' => 'required|email|unique:users,email',
                    'password' => 'required|min:5|confirmed',
                    'password_confirmation' => 'required|same:password',
                    'img' => 'max:255',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'username' => 'required|max:20|min:3|unique:users,username,'.$user->id.',id',
                    'email' => 'required|email|unique:users,email,'.$user->email.',email',
                    'first_name' => 'max:30',
                    'last_name' => 'max:30',
                    'company' => 'max:20',
                    'phone' => 'max:20',
                    'address_line_one' => '',
                    'address_line_two' => '',
                    'city' => 'max:20',
                    'state' => 'max:20',
                    'zip_code' => 'max:20',
                    'country' => 'max:20',
                    'img' => 'max:255',
                ];
            }
            default:break;
        }
    }
}
