<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Client', 'prefix' => 'admin/client', 'namespace' => '\Modules\Client\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('lang', 'ClientController@langUses')->name('client.languses');

    Route::get('/', 'ClientController@index')->name('client.list');
    Route::get('list', 'ClientController@clientDataTable')->name('client.list.datatable');

    Route::get('add', 'ClientController@add')->name('client.create');
    Route::post('add', 'ClientController@create')->name('client.create.post');

    Route::get('edit/{user}', 'ClientController@edit')->name('client.edit');
    Route::patch('edit/{user}/{client}', 'ClientController@update')->name('client.edit.post');

    Route::get('view/{user}', 'ClientController@view')->name('client.view');

    Route::get('password/update/{user}', 'ClientController@changePassword')->name('client.change-password');
    Route::post('password/update/{user}', 'ClientController@updatePassword')->name('client.update-password.post');

});

Route::group(['Module' => 'Client', 'prefix' => 'admin/client', 'namespace' => '\Modules\Client\Controllers', 'middleware' => ['web', 'installer', 'auth']], function() {
    Route::patch('profile/{user}/{client}', 'ClientController@updateProfile')->name('profile.client.edit.post');
});