<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Currency\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait CurrencyAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@currency-edit')) {
            return '<a href="' . route('currency.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Currency::currency.buttons.actions.edit') . '"></i></a> ';
        }

        return '';
    }

//    public function getViewButtonAttribute()
//    {
//        if(Auth::user()->hasPermission('admin@currency-view')) {
//            return '<a href="' . route('currency.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Currency::currency.buttons.actions.view') . '"></i></a> ';
//        }
//        return '';
//    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@currency-delete')) {
            //if ($this->user_id == auth()->id()) {
                return '<a href="' . route('currency.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger currency-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Currency::currency.buttons.actions.delete') . '"></i></a> ';
            //}
        }

        return "";
    }

    public function getStatusButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@currency-status')) {
            if ($this->status == 0)
                return "<a id=\"status\" class=\"btn btn-success btn-xs\" href=" . route('currency.status', $this) . " title='" . trans('Currency::currency.buttons.actions.status.active') . "'><i class='fa fa-play'></i></a> ";
            else
                return "<a id=\"status\" class=\"btn btn-danger btn-xs\" href=" . route('currency.status', $this) . " title='" . trans('Currency::currency.buttons.actions.status.deactive') . "'><i class='fa fa-pause'></i></a> ";
        }

    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getEditButtonAttribute().
            $this->getStatusButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}