@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($currency, [
        'method' => 'PATCH',
        'route' => ['currency.edit.post', $currency->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif

    <div class="box-body">
        <div class="form-group{{ $errors->has('currency_code') ? ' has-error' : '' }}">
            {!! Form::label('currency_code', trans("Currency::currency.inputs.currency_code"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('currency_code', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => 'Currency ISO Code like USD, GBP, BDT']) !!}
                {!! $errors->first('currency_code', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('currency_symbol') ? ' has-error' : '' }}">

            {!! Form::label('currency_symbol', trans("Currency::currency.inputs.currency_symbol"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('currency_symbol', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => 'Currency Symbol like $, £']) !!}
                {!! $errors->first('currency_symbol', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('conversion_rate') ? ' has-error' : '' }}">

            {!! Form::label('conversion_rate', trans("Currency::currency.inputs.conversion_rate"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('conversion_rate', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('conversion_rate', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('currency.list', trans('Currency::currency.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}


@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
<script>
    $(".textarea").wysihtml5();
</script>
@endpush