@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-money"></i> {{ trans('Currency::currency.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Currency::currency.optional_title.edit') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('currency.list') }}"><i class="fa fa-laptop"></i>{{ trans('Currency::currency.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Currency::currency.breadcrumb.second') }}</li>
@endsection
@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                @include('Currency::_form', ['submitButton' => trans('Currency::currency.buttons.update'), 'formFor' => 'edit', 'currency' => $currency])
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
