<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Currency', 'prefix' => 'admin/currency', 'namespace' => '\Modules\Currency\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('lang', 'CurrencyController@langUses')->name('currency.languses');

    Route::get('/', 'CurrencyController@index')->name('currency.list');
    Route::get('list', 'CurrencyController@currencyDataTable')->name('currency.list.datatable');

    Route::get('add', 'CurrencyController@add')->name('currency.create');
    Route::post('add', 'CurrencyController@create')->name('currency.create.post');

    Route::get('edit/{currency}', 'CurrencyController@edit')->name('currency.edit');
    Route::patch('edit/{currency}', 'CurrencyController@update')->name('currency.edit.post');

    Route::delete('delete/{currency}', 'CurrencyController@delete')->name('currency.destroy');
    Route::get('view/{currency}', 'CurrencyController@view')->name('currency.view');
    Route::get('status/{currency}', 'CurrencyController@status')->name('currency.status');

});
