<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Deposit\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait DepositAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@deposit-edit')) {
            return '<a href="' . route('deposit.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Deposit::deposit.buttons.actions.edit') . '"></i></a> ';
        }

        return '';
    }

//    public function getViewButtonAttribute()
//    {
//        if(Auth::user()->hasPermission('admin@deposit-view')) {
//            return '<a href="' . route('deposit.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Deposit::deposit.buttons.actions.view') . '"></i></a> ';
//        }
//        return '';
//    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@deposit-delete')) {
                return '<a href="' . route('deposit.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger deposit-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Deposit::deposit.buttons.actions.delete') . '"></i></a> ';
        }

        return "";
    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getEditButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}