<?php

namespace Modules\Deposit\Requests;

use App\Http\Requests\Request;

class DepositRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'bank_id' => 'required',
                    'description' => 'max:100',
                    'date' => 'date',
                    'amount' => 'required',
                    'attach' => 'max:10000|mimes:doc,docx,xlsx,jpeg,jpg,png'
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'bank_id' => 'required',
                    'description' => 'max:100',
                    'date' => 'date',
                    'amount' => 'required',
                    'attach' => 'max:10000|mimes:doc,docx,xlsx,jpeg,jpg,png'
                ];
            }
            default:break;
        }
    }
}
