<?php

namespace Modules\EmailTemplate\Requests;

use App\Http\Requests\Request;

class EmailTemplateRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        //$user = Iauth::find($this->segment(3));

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name' => 'required|max:30|min:3',
                    'template' => 'required|min:3',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'name' => 'required|max:30|min:3',
                    'template' => 'required|min:3',
                ];
            }
            default:break;
        }
    }
}
