@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($emailtemplate, [
        'method' => 'PATCH',
        'route' => ['emailtemplate.edit.post', $emailtemplate->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif

    <div class="box-body">
        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
            {!! Form::label('name', trans("EmailTemplate::emailtemplate.inputs.name"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('name', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('tags') ? ' has-error' : '' }}">
            {!! Form::label('tags', trans("EmailTemplate::emailtemplate.inputs.tags"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6 ">
                <div class="col-lg-12 border">
                    @foreach($tags as $tag)
                        <input class="btn bg-purple btn-xs email_tag" style="margin: 3px;" type="button" value="{{ $tag  }}" />
                    @endforeach
                </div>
            </div>
        </div>

        <div class="form-group{{ $errors->has('template') ? ' has-error' : '' }}">

            {!! Form::label('template', trans("EmailTemplate::emailtemplate.inputs.template"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::textarea('template', null, ['class' => 'form-control textarea col-xs-12', 'id' => 'template']) !!}
                {!! $errors->first('template', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('emailtemplate.list', trans('EmailTemplate::emailtemplate.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}


@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
{{--<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">--}}
<link rel="stylesheet" href="{{ url('bassets/plugins/editor/jquery-te-1.4.0.css') }}">
<style>
    .border {
        border: 1px solid #e2e7eb;
        min-height: 70px;
        padding: 1px 1px 1px 0;
    }
</style>
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/editor/jquery-te-1.4.0.min.js') }}"></script>
<script>
$(document).ready(function() {
    $('.email_tag').click(function() {
        var value = $(this).val();
        $(".jqte_editor").append(value);
    });

    $('#template').jqte();
});
</script>
@endpush