@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('EmailTemplate::emailtemplate.title') }}
@endsection
@section('moduleDescription')
    {{ trans('EmailTemplate::emailtemplate.optional_title.create') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('emailtemplate.list') }}"><i class="fa fa-laptop"></i>{{ trans('EmailTemplate::emailtemplate.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('EmailTemplate::emailtemplate.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                @include('EmailTemplate::_form', ['submitButton' => trans('EmailTemplate::emailtemplate.buttons.add'), 'formFor' => 'create'])
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
