<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('note')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->integer('user_id')->unsigned();
            $table->integer('expense_type_id')->unsigned();
            $table->integer('payment_type_id')->unsigned();
            $table->integer('purchased_id')->unsigned();
            $table->timestamp('purchased_date')->nullable();
            $table->integer('purchased_amount');
            $table->text('attach')->nullable();
            $table->timestamps();
            /**
             * Add Foreign/Unique/Index
             */
            $table->foreign('purchased_id')
                ->references('id')
                ->on(config('core.acl.users_table'))
                ->onUpdate('cascade');
            $table->foreign('user_id')
                ->references('id')
                ->on(config('core.acl.users_table'))
                ->onDelete('cascade');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('expenses');
        Schema::enableForeignKeyConstraints();
    }
}
