<?php

namespace Modules\Expense\Requests;

use App\Http\Requests\Request;

class ExpenseRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        //$user = Iauth::find($this->segment(3));

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|min:3',
                    'note' => 'max:250',
                    'expense_type_id' => 'required',
                    'payment_type_id' => 'required',
                    'purchased_id' => 'required',
                    'purchased_date' => 'required|date',
                    'purchased_amount' => 'required',
                    'attachment' => 'mimes:doc,docx,pdf,jpeg,jpg,png,gif|max:10000'
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'title' => 'required|min:3',
                    'note' => 'max:250',
                    'expense_type_id' => 'required',
                    'payment_type_id' => 'required',
                    'purchased_id' => 'required',
                    'purchased_date' => 'required|date',
                    'purchased_amount' => 'required',
                    'attachment' => 'mimes:jpeg,jpg,png,gif|max:100000',
                ];
            }
            default:break;
        }
    }
}
