@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Expense::expense.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Expense::expense.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('expense.list') }}"><i class="fa fa-laptop"></i>{{ trans('Expense::expense.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Expense::expense.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    {{--@roles([1])--}}
                    <a href="{{ route('expense.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Expense::expense.buttons.create') }}
                        </button>
                    </a>
                    {{--@endroles--}}
                    <table id="expenses-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ trans('Expense::expense.columns.purchased_by') }}</th>
                            <th>{{ trans('Expense::expense.columns.expense_type_id') }}</th>
                            <th>{{ trans('Expense::expense.columns.purchased_amount') }}</th>
                            <th>{{ trans('Expense::expense.columns.purchased_date') }}</th>
                            <th class="col-lg-2">{{ trans('Expense::expense.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#expenses-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("expense.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'purchased', name: 'purchased'},
                {data: 'expense_type_id', name: 'expense_type_id'},
                {data: 'purchased_amount', name: 'purchased_amount'},
                {data: 'purchased_date', name: 'purchased_date'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "desc"]],
            searchDelay: 500

        });

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush