@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Expense::expense.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Expense::expense.optional_title.view') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('expense.list') }}"><i class="fa fa-laptop"></i>{{ trans('Expense::expense.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Expense::expense.breadcrumb.second') }}</li>
@endsection


@section('moduleContent')

    <section class="invoice">
        <!-- title row -->
        <div class="row">
            <div class="col-xs-12">
                <img src="{{ url(get_logo()) }}" alt="logo">
                <h2 class="page-header pull-right">
                    {!! get_isite_sitename() !!}
                    <small>Date: {{ $expense->created_at->format('jS F Y') }}</small>
                </h2>
                <hr>
            </div>
            <!-- /.col -->
        </div>
        <!-- info row -->
        <div class="row invoice-info">
            <div class="col-sm-4 invoice-col">
                {{ trans('Expense::expense.others.registered_by') }}
                <address>
                    <strong>{!! get_site_name() !!}</strong><br>
                    Email: {{ isite()->siteEmail() }}
                </address>
            </div>
            <!-- /.col -->
            <div class="col-sm-4 invoice-col">
                {{ trans('Expense::expense.others.purchased_by') }}
                <address>
                    <strong>{{ $expense->purchased->name }}</strong><br>
                    Email: {{ $expense->purchased->email }}
                </address>
            </div>
            <!-- /.col -->
            <div class="col-sm-4 invoice-col">
                <b>{{ trans("Expense::expense.columns.expense_type_id") }} :</b> {{ $expense->expenseType->name }}<br>
                <b>{{ trans("Expense::expense.columns.payment_type_id") }} :</b> {{ $expense->paymentType->name }}<br>
                @if($expense->attach)
                <b>{{ trans("Expense::expense.columns.expense_attachment") }} :</b> <a target="_blank" href="{{ url("public/assets/img/expense/".$expense->attach) }}" class="btn btn-info btn-xs">{{ "Download" }}</a><br>
                @endif
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

        <div class="row">
            <!-- accepted payments column -->
            <div class="col-xs-6">
                <p class="lead">Expense Note</p>
                <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                    {!! $expense->note !!}
                </p>
            </div>

            <div class="col-xs-6">
                <p class="lead">{{ trans('Expense::expense.columns.purchased_amount') }}</p>
                <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                    {{ isite()->siteCurrencySymbol() }}{{ $expense->purchased_amount }}
                </p>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

        <!-- this row will not appear when printing -->
        {{--<div class="row no-print">--}}
            {{--<div class="col-xs-12">--}}
                {{--<button type="button" class="btn btn-primary pull-right" style="margin-right: 5px;">--}}
                    {{--<i class="fa fa-download"></i> Generate PDF--}}
                {{--</button>--}}
            {{--</div>--}}
        {{--</div>--}}
    </section>
    <div class="clearfix"></div>
@endsection
