<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Expense', 'prefix' => 'admin/expense', 'namespace' => '\Modules\Expense\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'ExpenseController@index')->name('expense.list');
    Route::get('list', 'ExpenseController@expenseDataTable')->name('expense.list.datatable');

    Route::get('add', 'ExpenseController@add')->name('expense.create');
    Route::post('add', 'ExpenseController@create')->name('expense.create.post');

    Route::get('edit/{expense}', 'ExpenseController@edit')->name('expense.edit');
    Route::patch('edit/{expense}', 'ExpenseController@update')->name('expense.edit.post');

    Route::delete('delete/{expense}', 'ExpenseController@delete')->name('expense.destroy');
    Route::get('view/{expense}', 'ExpenseController@view')->name('expense.view');
    Route::get('status/{expense}', 'ExpenseController@status')->name('expense.status');

});
