<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\ExpenseType\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\ExpenseType\Models\ExpenseType;
use Modules\ExpenseType\Repositories\ExpenseTypeRepository;
use Modules\ExpenseType\Requests\ExpenseTypeRequest;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache;

class ExpenseTypeController extends Controller
{
    protected $expensetypeRepo;

    function __construct(ExpenseTypeRepository $expensetype)
    {
        $this->expensetypeRepo = $expensetype;
    }

    public function index()
    {
        return view("ExpenseType::expensetypeList");
    }

    public function expensetypeDataTable()
    {
        return DataTables::of($this->expensetypeRepo->findAll(['*']))
            ->editColumn('note', function ($expensetype){
                $lenth = strlen($expensetype->note);
                if ($lenth > 99)
                    return substr($expensetype->note, 0, 100)."...";
                else
                    return $expensetype->note;
            })
            ->addColumn('actions', function ($expensetype){
                return $expensetype->action_buttons;
            })
            ->make(true);
    }

    public function add()
    {
        return view("ExpenseType::expensetypeCreate");
    }

    public function create(ExpenseTypeRequest $request)
    {
        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        $result = $this->expensetypeRepo->create($input);

        if ($result) {
            $this->removeCached();
            Alert::success(trans("ExpenseType::expensetype.alert.create_success"), 'success');
            return redirect()->route('expensetype.list');
        }
    }

    public function edit(ExpenseType $expensetype)
    {
        return view("ExpenseType::expensetypeEdit")->withExpensetype($expensetype);
    }

    public function update(ExpenseType $expensetype, ExpenseTypeRequest $request)
    {
        $result = $this->expensetypeRepo->update($expensetype, $request->all());

        if ($result) {
            $this->removeCached();
            Alert::success(trans("ExpenseType::expensetype.alert.update_success"), 'success');
            return redirect()->route('expensetype.list');
        }
    }

    public function view(ExpenseType $expensetype)
    {
        return $expensetype != null ? view("ExpenseType::expensetypeView")->withExpensetype($expensetype) :  abort(404);
    }

    public function status(ExpenseType $expensetype)
    {
        $data = [];
        if($expensetype->user_id == auth()->user()->id) {
            if ($expensetype->status==1) {
                $data['status'] = 0;
            } else {
                $data['status'] = 1;
            }
            $this->expensetypeRepo->update($expensetype->id, $data);
            $this->removeCached();
            Alert::success(trans("ExpenseType::expensetype.alert.status_success"), 'success');
        } else {
            Alert::error(trans("ExpenseType::expensetype.alert.status_error"), 'error');
        }

        return redirect()->route('expensetype.list');
    }

    public function delete(ExpenseType $expensetype)
    {
        if($expensetype->user_id == auth()->user()->id) {

            $this->expensetypeRepo->delete($expensetype->id);

            $this->removeCached();
            Alert::success(trans("ExpenseType::expensetype.alert.delete_success"), 'success');
            return redirect()->route('expensetype.list');
        } else {
            $this->removeCached();
            Alert::error(trans("ExpenseType::expensetype.alert.delete_error"), 'Error');
            return redirect()->route('expensetype.list');
        }
    }

    public function removeCached()
    {
        Cache::forget('expense_types');
    }


}
