<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'ExpenseType', 'prefix' => 'admin/type', 'namespace' => '\Modules\ExpenseType\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::group(['prefix' => 'expense'], function() {

        Route::get('/', 'ExpenseTypeController@index')->name('expensetype.list');
        Route::get('list', 'ExpenseTypeController@expensetypeDataTable')->name('expensetype.list.datatable');

        Route::get('add', 'ExpenseTypeController@add')->name('expensetype.create');
        Route::post('add', 'ExpenseTypeController@create')->name('expensetype.create.post');

        Route::get('edit/{expensetype}', 'ExpenseTypeController@edit')->name('expensetype.edit');
        Route::patch('edit/{expensetype}', 'ExpenseTypeController@update')->name('expensetype.edit.post');

        Route::delete('delete/{expensetype}', 'ExpenseTypeController@delete')->name('expensetype.destroy');
        Route::get('status/{expensetype}', 'ExpenseTypeController@status')->name('expensetype.status');
    });

});
