@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('ExportImport::exportimport.title') }}
@endsection
@section('moduleDescription')
    {{ trans('ExportImport::exportimport.optional_title.create') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('export.create') }}"><i class="fa fa-laptop"></i>{{ trans('ExportImport::exportimport.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('ExportImport::exportimport.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    @include('ExportImport::_form', ['submitButton' => trans('ExportImport::exportimport.buttons.add'), 'formFor' => 'create'])
                    <div id="hide-table">
                    <table  class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('ExportImport::exportimport.columns.one') }}</th>
                                <th>{{ trans('ExportImport::exportimport.columns.two') }}</th>
                                <th>{{ trans('ExportImport::exportimport.columns.three') }}</th>
                                <th>{{ trans('ExportImport::exportimport.columns.four') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach ($backups as $k => $b)
                            <tr>
                                <th scope="row">{{ $k+1 }}</th>
                                <td>{{ $b['disk'] }}</td>
                                <td>{{ \Carbon\Carbon::createFromTimeStamp($b['last_modified'])->formatLocalized('%d %B %Y, %H:%M') }}</td>
                                <td>{{ round((int)$b['file_size']/1048576, 2).' MB' }}</td>
                                <td>
                                    @if(Auth::user()->hasPermission('admin@export-download'))
                                        @if ($b['download'])
                                            <a class="btn btn-xs btn-primary" href="{{ url(config('backpack.base.route_prefix', 'admin').'/export/download/') }}?disk={{ $b['disk'] }}&path={{ urlencode($b['file_path']) }}&file_name={{ urlencode($b['file_name']) }}"><i class="fa fa-cloud-download"></i> </a>
                                        @endif
                                    @endif
                                    @if(Auth::user()->hasPermission('admin@export-delete'))
                                            {{--<a href="{{ url(config('backpack.base.route_prefix', 'admin').'/export/delete/'.$b['file_name']) }}?disk={{ $b['disk'] }}"--}}
                                            <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/export/delete/') }}?disk={{ $b['disk'] }}&path={{ urlencode($b['file_path']) }}&file_name={{ urlencode($b['file_name']) }}"
                                               data-method="delete"
                                               data-trans-button-cancel="Cancel"
                                               data-trans-button-confirm="Delete"
                                               data-trans-title="Are you sure?"
                                               class="btn btn-xs btn-danger export-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="{{ trans('ExportImport::exportimport.buttons.actions.delete') }}"></i></a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        @if(!count($backups))
                            <tr class="text-center">
                                <td colspan="5">
                                    {{ trans('ExportImport::exportimport.nobackups') }}
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
                </div>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
