<?php
/*
| -------------------------------------------------------------
| iStart - Laravel Multi Admin+Frontend Theme and Startup Tools
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Frontend\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Frontend\Models\Frontend;
use Modules\Frontend\Repositories\FrontendRepository;
use Modules\Frontend\Requests\FrontendRequest;
use Modules\Post\Models\Post;
use Yajra\Datatables\Facades\Datatables;

class FrontendController extends Controller
{
    protected $frontendRepo;

    function __construct(FrontendRepository $frontend)
    {
        $this->frontendRepo = $frontend;
    }

    public function index()
    {
        return view("frontend::pages.home");
    }

    public function singlePostView($slug)
    {
        $post = Post::where('slug', '=', $slug)->first();
        if($post == null) {
            abort(404);
        }
        return view('frontend::pages.singlePost')->withPost($post);
    }

    public function frontendDataTable()
    {
        return DataTables::of($this->frontendRepo->findAll(['*']))
            //->addColumn('users', function ($frontend){
            //    return $frontend->user->username;
            //})
            ->addColumn('actions', function ($frontend){
                return $frontend->action_buttons;
            })
            ->make(true);
    }

    public function add()
    {
        return view("Frontend::frontendCreate");
    }

    public function create(FrontendRequest $request)
    {
        $input = $request->all();
        $result = $this->frontendRepo->create($input);

        if ($result) {
            flash('Frontend successfully created!', 'success');
            return redirect('frontend');
        }
    }

    public function edit(Frontend $id)
    {
        $frontend = $id;
        return view("Frontend::frontendEdit")->withFrontend($frontend);
    }

    public function update(Frontend $id, FrontendRequest $request)
    {
        $result = $this->frontendRepo->update($id, $request->all());

        if ($result) {
            flash('Frontend successfully created!', 'success');
            return redirect('frontend');
        }
    }
}
