<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Controllers;

use App\Http\Controllers\Controller;
use Modules\Iauth\Models\Access\Permission\Permission;
use Modules\Iauth\Repositories\Access\Permission\PermissionRepositoryContract;
use Modules\Iauth\Requests\PermissionRequest;
use Yajra\Datatables\Facades\Datatables;
use Route;
use Alert, Cache;

class PermissionController extends Controller
{
    protected $permissionRepo;

    public function __construct(PermissionRepositoryContract $permission)
    {
        $this->permissionRepo = $permission;
    }

    public function index()
    {
        return view('Iauth::permission.permissionList');
    }

    public function add()
    {
        return view('Iauth::permission.permissionCreate');
    }

    public function edit(Permission $permission)
    {
        return view('Iauth::permission.permissionEdit')
            ->withSubPermissions($this->permissionRepo->getAllSubPermissions($permission)->pluck('name')->all())
            ->withPermission($permission);
    }

    public function permissionDataTable()
    {
        $this->removeCached();
        return Datatables::of($this->permissionRepo->getAllMainPermissions())
            ->addColumn('subpermission', function($permission) {

                $subPermission  = $this->permissionRepo->getAllSubPermissions($permission)->pluck('display_name', 'name')->all();


                //for Developer..
                return implode("<br/>", array_map(
                    function ($v, $k) {
                        $v = $v.' ('.$k.')';
                        return $v;
                    },
                    $subPermission,
                    array_keys($subPermission))
                );

                return implode("<br/>", $subPermission);

            })
            ->addColumn('actions', function ($permission) {
                return $permission->action_buttons;
            })
            ->make(true);
    }

    public function create(PermissionRequest $request)
    {
        $result = $this->permissionRepo->create(
            $request->except('permission_action'),
            $request->only('permission_action')
        );

        if($result) {
            $this->removeCached();
            Alert::success(trans("Iauth::permission.alert.role_add_success"), 'success');
            return redirect(route('permission.list'));
        }
    }

    public function update(Permission $permission, PermissionRequest $request)
    {
        $this->permissionRepo->update($permission,
            $request->except('permission_action'),
            $request->only('permission_action')
        );
        $this->removeCached();
        Alert::success(trans("Iauth::permission.alert.update_success"), 'success');
        return redirect(route('permission.list'));
    }

    public function status(Permission $permission, $status)
    {
        $this->permissionRepo->changeActiveStatus($permission, $status);
        $this->removeCached();
        Alert::success(trans("Iauth::permission.alert.update_success"), 'success');
        return redirect()->back();
    }

    public function auto()
    {
        $this->removeCached();

        $routeCollection = Route::getRoutes();

        $f                      = false;
        $allRouteLikeDatabase   = [];
        foreach ($routeCollection as $value) {
            $middleware         =   false;
            if ( isset($value->getAction()['middleware']) && is_array($value->getAction()['middleware']) ) {
                $middleware     =   in_array('acl', $value->getAction()['middleware']);
            }

            if ($middleware) {
                $permission                     =   [];
                $explodeUrl                     =   explode('/', $value->getpath());
                $countExplode                   =   count($explodeUrl);

                for ($i = 1; $i <= $countExplode; $i++) {
                    if($explodeUrl[$i-1][0] != '{') {
                        if($i == 1) {
                            $permission['name']             =   $explodeUrl[$i-1];
                            $permission['display_name']     =   ucfirst($explodeUrl[$i-1]);
                        } elseif($i==2 && $explodeUrl[$i-2] == 'admin') {
                            $permission['name']             .=   '@'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        } else {
                            $permission['name']             .=   '-'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        }

                    }
                }

                $allRouteLikeDatabase[]         =   $permission['name'];
                if(isset($permission)) {
                    $status = $this->permissionRepo->firstOrCreate($permission);
                }
                if ($status->wasRecentlyCreated) {
                    $f  =   true;
                }
            }
        }

        $deletePermissionFromDatabaseWithCheckRoutes   =   array_count_values(array_merge($this->permissionRepo->getAllPermissions()->pluck('name')->all(), $allRouteLikeDatabase));

        foreach ($deletePermissionFromDatabaseWithCheckRoutes as $name => $value) {
            if($value == 1) {
                $this->permissionRepo->deleteWithPermissionName($name);
                $f  =   true;
            }
        }
        if ($f) {
            flash(trans("Iauth::permission.alert.update_success_general"), 'success');
            return redirect(route('permission.list'));
        }

        flash(trans("Iauth::permission.alert.no_route"), 'error');
        return redirect(route('permission.list'));
    }

    public function removeCached()
    {
        Cache::forget('permission-status');
        Cache::forget('permission');
        Cache::forget('permission-role-relation');
    }
}