<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Controllers;

use App\Http\Controllers\Controller;
//use App\Http\Requests\Request;
use Illuminate\Http\Request;
use Modules\Iauth\Events\Access\Role\RoleDeleted;
use Modules\Iauth\Repositories\Access\Role\RoleRepositoryContract;
use Modules\Iauth\Requests\RoleRequest;

use Modules\Iauth\Models\Access\User\User;
use Modules\Iauth\Models\Access\Role\Role;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache;

class RoleController extends Controller
{
    protected $roleRepo;

    public function __construct(RoleRepositoryContract $role)
    {
        $this->roleRepo  = $role;
    }

	public function index()
	{
        return view('Iauth::role.roleList')
            ->withRoles($this->roleRepo->getAllRoles());
	}

	public function add()
	{
        return view('Iauth::role.roleCreate');
	}

    public function edit(Role $role)
    {
        return view('Iauth::role.roleEdit')
                ->withRole($role);
    }

    public function roleDataTable()
    {
        $this->removeCached();
        return Datatables::of($this->roleRepo->getAllRoles())
            ->addColumn('users', function($role) {
                return $role->users()->count();
            })
            ->addColumn('actions', function ($role) {
                return $role->action_buttons;
            })
            ->make(true);
	}

	public function create(RoleRequest $request)
	{
        $result = $this->roleRepo->create($request);

        if($result) {
            $this->removeCached();
            Alert::success(trans("Iauth::role.alert.create_success"), 'success');
            return redirect(route('role.list'));
        }
	}

    public function update(Role $role, RoleRequest $request)
    {
        $this->roleRepo->update($role, $request->all());

        Alert::success(trans("Iauth::role.alert.update_success"), 'success');
        return redirect(route('role.list'));
    }

    public function delete($role)
    {
        $role = Role::findOrFail($role);
        if($role) {
            $role->delete();
            $this->removeCached();
            event(new RoleDeleted($role));
            Alert::success(trans("Iauth::role.alert.delete_success"), 'success');
        }

        return redirect(route('role.list'));
    }

    public function removeCached()
    {
        Cache::forget('roles_with_permission');
        Cache::forget('roles_orderby');
    }

}
