<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Listeners\Access\Role\History;

/**
 * Class RoleEventListener
 * @package App\Listeners\Backend\Access\Role
 */
class RoleEventListener
{
	/**
	 * @var string
	 */
	private $history_slug = 'Role';

	/**
	 * @param $event
	 */
	public function onCreated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.roles.created") <strong>'.$event->role->name.'</strong>',
			$event->role->id,
			'plus',
			'bg-green'
		);
	}

	/**
	 * @param $event
	 */
	public function onUpdated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.roles.updated") <strong>'.$event->role->name.'</strong>',
			$event->role->id,
			'save',
			'bg-aqua'
		);
	}

	/**
	 * @param $event
	 */
	public function onDeleted($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.roles.deleted") <strong>'.$event->role->name.'</strong>',
			$event->role->id,
			'trash',
			'bg-maroon'
		);
	}

	/**
	 * Register the listeners for the subscriber.
	 *
	 * @param  \Illuminate\Events\Dispatcher  $events
	 */
	public function subscribe($events)
	{
		$events->listen(
			\Modules\Iauth\Events\Access\Role\RoleCreated::class,
			'Modules\Iauth\Listeners\Access\Role\History\RoleEventListener@onCreated'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\Role\RoleUpdated::class,
			'Modules\Iauth\Listeners\Access\Role\History\RoleEventListener@onUpdated'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\Role\RoleDeleted::class,
			'Modules\Iauth\Listeners\Access\Role\History\RoleEventListener@onDeleted'
		);
	}
}