<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Listeners\Access\User\History;

/**
 * Class UserEventHistoryListener
 * @package Modules\Iauth\Listeners\Access\User
 */
class UserEventHistoryListener
{
	/**
	 * @var string
	 */
	private $history_slug = 'User';

	/**
	 * @param $event
	 */
	public function onCreated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.created") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'plus',
			'bg-green'
		);

	}

	/**
	 * @param $event
	 */
	public function onUpdated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.updated") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'save',
			'bg-aqua'
		);
	}

	/**
	 * @param $event
	 */
	public function onDeleted($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.deleted") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'trash',
			'bg-maroon'
		);
	}

	/**
	 * @param $event
	 */
	public function onRestored($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.restored") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'refresh',
			'bg-aqua'
		);
	}

	/**
	 * @param $event
	 */
	public function onPermanentlyDeleted($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.permanently_deleted") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'trash',
			'bg-maroon'
		);
	}

	/**
	 * @param $event
	 */
	public function onPasswordChanged($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.changed_password") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'lock',
			'bg-blue'
		);
	}

	/**
	 * @param $event
	 */
	public function onDeactivated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.deactivated") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'times',
			'bg-yellow'
		);
	}

	/**
	 * @param $event
	 */
	public function onReactivated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.users.reactivated") <strong>'.$event->user->username.'</strong>',
			$event->user->id,
			'check',
			'bg-green'
		);
	}

	/**
	 * Register the listeners for the subscriber.
	 *
	 * @param  \Illuminate\Events\Dispatcher  $events
	 */
	public function subscribe($events)
	{
		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserCreated::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onCreated'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserUpdated::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onUpdated'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserDeleted::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onDeleted'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserRestored::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onRestored'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserPermanentlyDeleted::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onPermanentlyDeleted'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserPasswordChanged::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onPasswordChanged'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserDeactivated::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onDeactivated'
		);

		$events->listen(
			\Modules\Iauth\Events\Access\User\History\UserReactivated::class,
			'Modules\Iauth\Listeners\Access\User\History\UserEventHistoryListener@onReactivated'
		);
	}
}