<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Models\Access\User;

use Illuminate\Notifications\Notifiable;
use Modules\Iauth\Models\Access\User\Traits\UserAccess;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Modules\Iauth\Models\Access\User\Traits\Attribute\UserAttribute;
use Modules\Iauth\Models\Access\User\Traits\Relationship\UserRelationship;
use Modules\Iauth\Services\ResetPasswordNotify;

/**
 * Class User
 * @package Modules\Iauth\Models\Access\User
 */
class User extends Authenticatable
{

    use SoftDeletes, UserAccess, UserAttribute, UserRelationship, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
//    protected $fillable = ['username', 'email', 'password', 'status', 'confirmation_code', 'is_valid_email'];

//    protected $guarded = ['username', 'email', 'password', 'status', 'confirmation_code', 'is_valid_email'];

    protected $guarded = [];
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = ['password', 'remember_token'];

    /**
     * @var array
     */
    protected $dates = ['deleted_at'];

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotify($token));
    }
}
