<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Repositories\Access\Permission;
use Illuminate\Support\Facades\DB;
use Modules\Iauth\Models\Access\Permission\Permission;
use Modules\Iauth\Models\Access\Role\Role;
use Cache;

class EloquentPermissionAssignRepository implements PermissionAssignRepositoryContract
{
    public function getRolePermissionAccess()
    {
        $permission_role    = config('core.acl.permission_role_table');
        $permissions       = config('core.acl.permissions_table');
        $roles              = config('core.acl.roles_table');

        $results = Cache::remember('permission-role-relation', 60, function() use($roles, $permissions, $permission_role) {
             return Permission::leftJoin($roles, $permissions . '.status', '=', DB::raw('1'))
                ->leftJoin($permission_role,
                    function ($join) use ($permission_role, $permissions, $roles) {
                        $join->on($permission_role . '.permission_id', '=', $permissions . '.id')
                            ->on($permission_role . '.role_id', '=', $roles . '.id');
                    }
                )
                ->where($permissions . '.status', '=', 1)
                ->select(DB::raw("CONCAT($permissions.name, '-', $roles.name) as role_permission, 
                            (case when $permission_role.permission_id = $permissions.id 
                                        and $permission_role.role_id = $roles.id then '1' 
                                  else '0' end) as active")
                )
                ->get();
            });

        return $results;
    }

    public function updateRolePermissionAccess($input)
    {
        DB::transaction(function() use ($input) {
            $oldPermission  = $this->getRolePermissionAccess()->pluck('active', 'role_permission')->toArray();
            $rolesDelete    = [];
            $rolesAdd       = [];
            foreach ($input as $key => $role_permission) {
                $explodeArray       = explode(',', $role_permission);
                if($oldPermission[$key] && $explodeArray[0] == 0) {
                    $rolesDelete[$explodeArray[2]][]      = $explodeArray[1];
                } elseif (!$oldPermission[$key]  && $explodeArray[0] != 0) {
                    $rolesAdd[$explodeArray[1]][]      = $explodeArray[0];
                }
            }

            if(count($rolesAdd)) {
                foreach ($rolesAdd as $role => $permissions) {
                    Role::find($role)->attachPermissions($permissions);
                }
            }

            if(count($rolesDelete)) {
                foreach ($rolesDelete as $role => $permissions) {
                    Role::find($role)->detachPermissions($permissions);
                }
            }
        });
    }
}