<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Repositories\Access\Permission;

use Modules\Iauth\Models\Access\Permission\Permission;
use Illuminate\Support\Facades\DB;
use Cache;

/**
 * Class EloquentPermissionRepository
 * @package App\Repositories\Permission
 */
class EloquentPermissionRepository implements PermissionRepositoryContract
{

	/**
     * @param string $order_by
     * @param string $sort
     * @return mixed
     */
    public function getAllPermissions($status = false)
    {
        if($status) {
            return Cache::remember('permission-status', 60, function () {
                return Permission::whereStatus(1)->get();
            });
        }
        return Cache::remember('permission', 60, function () {
            return Permission::all();
        });
    }

    public function getAllMainPermissions($status = false)
    {
        if($status) {
            return Permission::where('name', 'NOT like', '%-%')->whereStatus(1)->get();
        }
        return Permission::where('name', 'NOT like', '%-%')->get();
    }

    public function getAllSubPermissions(Permission $permission, $status = true)
    {
        if(!$status) {
            return Permission::where('name', 'like', $permission->name.'-%')->get();
        }

        return Permission::where('name', 'like', $permission->name.'-%')->whereStatus(1)->get();
    }

    /**
     * @param  $input
     * @return mixed
     */
    public function create($input, $action = [])
    {
        return DB::transaction(function() use ($input, $action) {

            $input['name']              = strtolower($input['name']);

            $permission                 = new Permission;
            $permission->display_name   = $input['display_name'];
            $permission->name           = $input['name'];
            $permission->description    = $input['description'];

            if ($permission->save()) {

                if(isset($action['permission_action'])) {
                    if(count($action['permission_action']) > 0 ) {

                        foreach ($action['permission_action'] as $permissionAction) {
                            $permissionHave                 = Permission::whereName($input['name'].'-'.$permissionAction)->count();
                            if($permissionHave == 0) {
                                $permission                 = new Permission;
                                $permission->display_name   = $input['display_name'].' '.ucfirst($permissionAction);
                                $permission->name           = $input['name'].'-'.$permissionAction;
                                $permission->description    = $input['name'].' sub-permission '.$permissionAction;
                                $permission->save();
                            }
                        }

                    }
                }

                return true;
            }

            return false;
        });
    }

    public function update(Permission $permission, $input, $action)
    {
        return DB::transaction(function() use ($permission, $input, $action) {

            $input['name']          = strtolower($input['name']);
            $getAllSubPermission    = $this->getAllSubPermissions($permission, false);

            $newPermissionAction = [];
            if(isset($action['permission_action']) && count($action['permission_action']) > 0) {

                foreach ($action['permission_action'] as $permissionAction) {
                    $newPermissionAction[$input['name'].'-'.$permissionAction] = true;
                }
            }
            
            foreach ($getAllSubPermission as $subPermission) {
                $new['name'] = str_replace($permission->name, $input['name'], $subPermission->name);
                $new['display_name'] = str_replace($permission->display_name, $input['display_name'], $subPermission->display_name);
                if(isset($newPermissionAction[$new['name']]) && $newPermissionAction[$new['name']]){
                    $new['status'] = 1;
                    $newPermissionAction[$new['name']] = false;
                } else {
                    $new['status'] = 0;
                }
                $subPermission->fill($new)->save();
            }

            $permission->fill($input)->save();

            foreach ($newPermissionAction as $permissionAction => $status) {
                if($status) {
                    $permission                 = new Permission;
                    $permission->display_name   = $input['display_name'].' '.ucfirst(substr(strstr($permissionAction, '-'),1));
                    $permission->name           = $permissionAction;
                    $permission->save();
                }
            }

            return true;
        });
    }

    public function changeActiveStatus($permission, $status)
    {
        return DB::transaction(function() use ($permission, $status) {
            $permission->status = $status;
            $permission->save();
            return true;
        });
    }

    public function firstOrCreate($permission)
    {
        return  DB::transaction(function () use ($permission) {
            $create = Permission::firstOrCreate($permission);
            return $create;
        });
    }

    public function deleteWithPermissionName($name)
    {
        return  DB::transaction(function () use ($name) {
            $permission = Permission::whereName($name);
            $permission->delete();
            return true;
        });
    }
}