<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Repositories\Access\Permission;
use Modules\Iauth\Models\Access\Permission\Permission;

/**
 * Interface PermissionRepositoryContract
 * @package App\Repositories\Permission
 */
interface PermissionRepositoryContract
{

    /**
     * @param  string  $order_by
     * @param  string  $sort
     * @return mixed
     */
    public function getAllPermissions($status = false);

    public function getAllMainPermissions($status = false);

    public function getAllSubPermissions(Permission $permission, $status = true);

    public function update(Permission $permission, $input, $action);

    public function changeActiveStatus($permission, $status);

    public function firstOrCreate($permission);

    public function deleteWithPermissionName($name);

    /**
     * @param  $input
     * @return mixed
     */
    public function create($input);

}