<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Repositories\Access\Role;

use Cache;
use Modules\Iauth\Events\Access\Role\RoleCreated;
use Modules\Iauth\Events\Access\Role\RoleUpdated;
use Modules\Iauth\Models\Access\Role\Role;
use Illuminate\Support\Facades\DB;

/**
 * Class EloquentRoleRepository
 * @package app\Repositories\Role
 */
class EloquentRoleRepository implements RoleRepositoryContract
{
    /**
     * @param int $status
     * @param bool $trashed
     * @return mixed
     */
    public function getAllRoles($order_by = 'sort', $sort = 'asc', $withPermissions = false)
    {
        if ($withPermissions) {
            return get_or_call('roles_with_permission', Role::with('permissions')
                ->orderBy($order_by, $sort)
                ->get());
        }

        return Cache::remember('roles_orderby', 60, function () use ($order_by, $sort) {
            return Role::orderBy($order_by, $sort)->get();
        });
    }

    /**
     * @param  $input
     * @return mixed
     */
    public function create($input)
    {
        return DB::transaction(function() use ($input) {
			$role       = new Role;
			$role->name = $input['name'];
			$role->sort = $input['sort'];

			if ($role->save()) {
			    event(new RoleCreated($role));
				return true;
			}

			return false;
        });
    }
    
	/**
     * @return mixed
     */
    public function getCount() {
        return Role::count();
    }

    /**
     * @param  Role $role
     * @param  $input
     * @throws GeneralException
     * @return bool
     */
    public function update(Role $role, $input)
    {
        $role->fill($input)->save();
        event(new RoleUpdated($role));
        return true;
    }
//
//    /**
//     * @param  Role $role
//     * @throws GeneralException
//     * @return bool
//     */
//    public function destroy(Role $role)
//    {
//        //Would be stupid to delete the administrator role
//        if ($role->id == 1) { //id is 1 because of the seeder
//            throw new GeneralException(trans('exceptions.backend.access.roles.cant_delete_admin'));
//        }
//
//        //Don't delete the role is there are users associated
//        if ($role->users()->count() > 0) {
//            throw new GeneralException(trans('exceptions.backend.access.roles.has_users'));
//        }
//
//		DB::transaction(function() use ($role) {
//			//Detach all associated roles
//			$role->permissions()->sync([]);
//
//			if ($role->delete()) {
////				event(new RoleDeleted($role));
//				return true;
//			}
//
//			throw new GeneralException(trans('exceptions.backend.access.roles.delete_error'));
//		});
//    }
//
//	/**
//	 * @return mixed
//	 */
//	public function getDefaultUserRole() {
//		if (is_numeric(config('access.users.default_role'))) {
//			return Role::where('id', (int) config('access.users.default_role'))->first();
//		}
//		return Role::where('name', config('access.users.default_role'))->first();
//	}
}