<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Requests;

use App\Http\Requests\Request;
use Modules\Iauth\Models\Access\Permission\Permission;

class PermissionRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $permission = $this->route('permission');

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name'          => 'required|max:20|unique:permissions,name',
                    'display_name'  => 'required',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'name'          => 'required|max:20|unique:permissions,name,'.$permission->name.',name',
                    'display_name'  => 'required',
                ];
            }
            default:break;
        }
    }
}
