@role('Admin')
    @extends('backend::pages.module')

    @section('moduleTitle')
        <i class="fa fa-user-plus"></i> {{ trans('Iauth::permission.title_assign') }}
    @endsection
    @section('moduleDescription')
        {{ trans('Iauth::permission.optional_title.assign') }}
    @endsection

    @section('moduleBreadcrumb')
        <li><a href="{{ route('permission.list') }}"><i class="fa fa-user-plus"></i>{{ trans('Iauth::permission.breadcrumb.first') }}</a></li>
        <li class="active">{{ trans('Iauth::permission.breadcrumb.assign') }}</li>
    @endsection

    @section('moduleContent')
        {!! Form::open(['class' => 'form-horizontal', 'route' => ['permission.assign.update']]) !!}
    <div class="row">
        <div class="col-xs-12">
            {{--<a href="{{ url('permission/add') }}">--}}
                {{--<button type="button" class="btn bg-purple btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">--}}
                    {{--<i class="fa fa-plus"></i>--}}
                    {{--Create Permission--}}
                {{--</button>--}}
            {{--</a>--}}
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                <div class="box-body">
                    <table id="permissions-table" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans("Iauth::permission.columns.assign") }}</th>
                                @forelse ($roles as $role)
                                    <th>{{ $role->name }}</th>
                                    @empty
                                        <th>No Roles</th>
                                @endforelse
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($permissions as $permissionKey)
                                @foreach($permissionKey as $key => $permission)
                                    <tr>
                                        @if($key != 'this')
                                            <td>{{ str_repeat('&nbsp;',8).'&rarr; '.ucfirst($key) }}</td>
                                        @else
                                            <td>{{ $permission->display_name }}</td>
                                        @endif
                                            @foreach($roles as $role)
                                                <td>
                                                    <input type="hidden" value="0,{{ $permission->id.','.$role->id }}" name="{{ $permission->name.'-'.$role->name }}">
                                                    @if($key == 'this')
                                                        <input type="checkbox" onclick="$(this).processCheck();" id="{{ $role->name.'-'.$permission->name }}" class="module" value="{{ $permission->id.','.$role->id }}" name="{{ $permission->name.'-'.$role->name }}"
                                                               @if($role_permission[$permission->name.'-'.$role->name]) checked="checked" @endif>
                                                    @else
                                                        <input type="checkbox" id="{{ $role->name.'-'.$permission->name }}" value="{{ $permission->id.','.$role->id }}" name="{{ $permission->name.'-'.$role->name }}"
                                                               @if($role_permission[$permission->name.'-'.$role->name]) checked="checked" @endif>
                                                    @endif

                                                    {{--<input type="checkbox" onclick="$(this).processCheck();" id="{{ $permission->name.'-'.$role->name }}" class="module" value="{{ $permission->id.','.$role->id }}" name="{{ $permission->name.'-'.$role->name }}"--}}
                                                           {{--@if($role_permission[$permission->name.'-'.$role->name]) checked @endif>--}}
                                                </td>
                                                {{--<td>{{ $role->name }}</td>--}}
                                            @endforeach
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                    </table>
                </div><!-- /.box-body -->
                <div class="box box-info">
                    <div class="box-body">
                        <div class="pull-left">
                            {{ link_to_route('backend.home', trans('Iauth::permission.buttons.cancel'), [], ['class' => 'btn btn-danger btn-lg']) }}
                        </div><!--pull-left-->

                        <div class="pull-right">
                            {{ Form::submit(trans("Iauth::permission.buttons.update"), ['class' => 'btn btn-success btn-lg']) }}
                        </div><!--pull-right-->

                        <div class="clearfix"></div>
                    </div><!-- /.box-body -->
                </div><!--box-->
            </div><!-- /.box -->
        </div>
    </div>


    @endsection


    @push('footerAssetPush')
    <script type="application/javascript">
        $.fn.processCheck = function() {
            var id = $(this).attr('id');
            id     = id.replace("@", "\\@");
            if ($('input#'+id).is(':checked')) {

                $( "input[id^='"+id+"']" ).prop('checked', true);
                $( "input[id^='"+id+"']" ).prop('disabled', false);
                $('input#'+id).prop('disabled', false);

            } else {

//                $( "input[id^='"+id+"']" ).prop('checked', false);
//                $( "input[id^='"+id+"']" ).prop('disabled', true);
//                $('input#'+id).prop('disabled', false);

            }
        };

//        $.fn.clearCheck = function() {
//            $( "input[type=checkbox]").prop('checked', false);
//            $( "input[type=checkbox]").prop('disabled', true);
//            $( ".module").prop('disabled', false);
//
//        };

//        $().ready(function() {
//            $.fn.clearCheck();
//        });
    </script>
    @endpush
@endrole