@role(1)
	@extends('backend::pages.module')


	@section('moduleTitle')
		<i class="fa fa-unlock"></i> {{ trans('Iauth::permission.title') }}
	@endsection
	@section('moduleDescription')
		{{ trans('Iauth::permission.optional_title.list') }}
	@endsection

	@section('moduleBreadcrumb')
		<li><a href="{{ route('permission.list') }}"><i class="fa fa-unlock"></i>{{ trans('Iauth::permission.breadcrumb.first') }}</a></li>
		<li class="active">{{ trans('Iauth::permission.breadcrumb.list') }}</li>
	@endsection

	@section('moduleContent')
	<div class="row">
		<div class="col-xs-12">
			<div class="box">
				<div class="box-header">
					<section class="content-header">
						<h1 class="box-title">
							@yield('moduleTitle', 'New Monule')
							<small>@yield('moduleDescription', 'Optional description')</small>
						</h1>
						<ol class="breadcrumb">
							@yield('moduleBreadcrumb', '
								 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
								 <li class="active">Here</li>
							')
						</ol>
					</section>
				</div>
				<div class="box-body">
					<a href="{{ route('permission.add') }}">
						<button type="button" class="btn btn-flat margin-bottom" data-toggle="tooltip" data-placement="top" title="Create Permission">
							<i class="fa fa-plus"></i>
							{{ trans('Iauth::permission.buttons.create') }}
						</button>
					</a>
					<a href="{{ route('permission.auto') }}">
						<button type="button" class="btn btn-flat margin-bottom pull-right btn-danger" data-toggle="tooltip" data-placement="top" title="Auto Create Permission From Route under ACL middleware">
							<i class="fa fa-bicycle"></i>
							{{ trans('Iauth::permission.buttons.create_auto') }}
						</button>
					</a>
				  <table id="permissions-table" class="table table-bordered table-striped">
					<thead>
					  <tr>
						<th data-title="#">#</th>
						<th data-title="{{ trans('Iauth::permission.columns.one') }}">{{ trans('Iauth::permission.columns.one') }}</th>
						<th data-title="{{ trans('Iauth::permission.columns.two') }}">{{ trans('Iauth::permission.columns.two') }}</th>
						<th data-title="{{ trans('Iauth::permission.columns.three') }}">{{ trans('Iauth::permission.columns.three') }}</th>
						<th data-title="{{ trans('Iauth::permission.columns.four') }}">{{ trans('Iauth::permission.columns.four') }}</th>
						<th data-title="{{ trans('Iauth::permission.columns.five') }}">{{ trans('Iauth::permission.columns.five') }}</th>
					  </tr>
					</thead>
				  </table>
				</div><!-- /.box-body -->
			</div><!-- /.box -->
		</div>
	</div>


	@endsection


	@push('footerAssetPush')
	<script type="application/javascript">
		$(function() {
			var t = $('#permissions-table').DataTable({
				processing: true,
				serverSide: true,
				ajax: '{{ route("permission.list.datatable") }}',
				buttons: [
					'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
				],
				columns: [
					{data: 'id', name: 'id'},
					{data: 'name', name: 'name'},
					{data: 'display_name', name: 'display_name'},
					{data: 'description', name: 'description'},
					{data: 'subpermission', name: 'subpermission'},
					{data: 'actions', name: 'actions'}
				],
				createdRow: function( row, data, dataIndex ) {
					$( row ).find('td:eq(0)').attr('data-title', '#');
					$( row ).find('td:eq(1)').attr('data-title', '{{ trans('Iauth::permission.columns.one') }}');
					$( row ).find('td:eq(2)').attr('data-title', '{{ trans('Iauth::permission.columns.two') }}');
					$( row ).find('td:eq(3)').attr('data-title', '{{ trans('Iauth::permission.columns.three') }}');
					$( row ).find('td:eq(4)').attr('data-title', '{{ trans('Iauth::permission.columns.four') }}');
					$( row ).find('td:eq(5)').attr('data-title', '{{ trans('Iauth::permission.columns.five') }}');
				},
				searchDelay: 500
			});

			t.on( 'order.dt search.dt', function () {
				t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
					cell.innerHTML = i+1;
				} );
			} ).draw();
		});
	</script>
	@endpush
@endrole