@extends('backend::pages.module')

@section('moduleTitle')
	<i class="fa fa-users"></i> {{ trans('Iauth::role.title') }}
@endsection
@section('moduleDescription')
	{{ trans('Iauth::role.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
	<li><a href="{{ route('role.list') }}"><i class="fa fa-users"></i>{{ trans('Iauth::role.breadcrumb.first') }}</a></li>
	<li class="active">{{ trans('Iauth::role.breadcrumb.list') }}</li>
@endsection


@section('moduleContent')
<div class="row">
	<div class="col-xs-12">

		{{--@permission("user-edit")--}}
		{{--<h1>Ok</h1>--}}
		{{--@endpermission--}}
	  	<div class="box">
		    <div class="box-header">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1 class="box-title">
						@yield('moduleTitle', 'New Monule')
						<small>@yield('moduleDescription', 'Optional description')</small>
					</h1>
					<ol class="breadcrumb">
						@yield('moduleBreadcrumb', '
                             <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                             <li class="active">Here</li>
                        ')
					</ol>
				</section>
		    </div><!-- /.box-header -->
		    <div class="box-body">
				{{--@roles([1])--}}
				@permission('admin@role-add')
				<a href="{{ route('role.add') }}">
					<button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
						<i class="fa fa-plus"></i>
						{{ trans('Iauth::role.buttons.create') }}
					</button>
				</a>
				@endpermission
				{{--@endroles--}}
				<div id="hide-table">
					<table id="roles-table" class="table table-striped table-bordered table-hover no-footer">
						<thead>
							<tr>
								<th data-title="#">#</th>
								<th data-title="{{ trans('Iauth::role.columns.one') }}">{{ trans('Iauth::role.columns.one') }}</th>
								<th data-title="{{ trans('Iauth::role.columns.two') }}">{{ trans('Iauth::role.columns.two') }}</th>
								<th data-title="{{ trans('Iauth::role.columns.three') }}">{{ trans('Iauth::role.columns.three') }}</th>
								<th data-title="{{ trans('Iauth::role.columns.four') }}">{{ trans('Iauth::role.columns.four') }}</th>
							</tr>
						</thead>
					</table>
				</div>
		    </div><!-- /.box-body -->
	  	</div><!-- /.box -->
	</div>
</div>


@endsection


@push('footerAssetPush')
<script type="application/javascript">
	$(function() {
		var t = $('#roles-table').DataTable({
			processing: true,
			serverSide: true,
			responsive: true,
			ajax: '{{ route("role.list.datatable") }}',
			buttons: [
				'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
			],
			columns: [
				{data: 'id', name: 'id'},
				{data: 'name', name: 'name'},
				{data: 'users', name: 'users'},
				{data: 'sort', name: 'sort'},
				{data: 'actions', name: 'actions', orderable: false, searchable: false}
			],
			createdRow: function( row, data, dataIndex ) {
				$( row ).find('td:eq(0)').attr('data-title', '#');
				$( row ).find('td:eq(1)').attr('data-title', '{{ trans('Iauth::role.columns.one') }}');
				$( row ).find('td:eq(2)').attr('data-title', '{{ trans('Iauth::role.columns.two') }}');
				$( row ).find('td:eq(3)').attr('data-title', '{{ trans('Iauth::role.columns.three') }}');
				$( row ).find('td:eq(4)').attr('data-title', '{{ trans('Iauth::role.columns.four') }}');
			},
			order: [[3, "asc"]],
			searchDelay: 500
		});

			t.on( 'order.dt search.dt', function () {
				t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
					cell.innerHTML = i+1;
				} );
			} ).draw();
	});
</script>
@endpush