@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal', 'enctype' => 'multipart/form-data']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($user, [
        'method' => 'PATCH',
        'route' => ['user.edit.post', $user->id],
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data'
    ]) !!}
@elseif ($formFor == 'editProfile')
    {!! Form::model($user, [
        'method' => 'PATCH',
        'route' => ['profile.edit.post', $user->id],
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data'
    ]) !!}
@endif
    <div class="box-body">
        <div class="form-group{{ $errors->has('username') ? ' has-error' : '' }}">

            {!! Form::label('username', trans("Iauth::user.inputs.one"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('username', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('username', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('first_name') ? ' has-error' : '' }}">

            {!! Form::label('first_name',  trans("Iauth::user.inputs.two"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('first_name', null, ['class' => 'form-control']) !!}
                {!! $errors->first('first_name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('last_name') ? ' has-error' : '' }}">

            {!! Form::label('last_name',  trans("Iauth::user.inputs.three"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('last_name', null, ['class' => 'form-control']) !!}
                {!! $errors->first('last_name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">

            {!! Form::label('email',  trans("Iauth::user.inputs.four"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('email', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('email', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        @if ($formFor == 'create')
            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">

                {!! Form::label('password',  trans("Iauth::user.inputs.five"), ['class' => 'col-lg-2 control-label']) !!}

                <div class="col-lg-6">
                    {!! Form::password('password', ['class' => 'form-control']) !!}
                    {!! $errors->first('password', '<span class="help-block">:message</span>') !!}
                </div>
            </div>

            <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">

                {!! Form::label('password_confirmation', trans("Iauth::user.inputs.six"), ['class' => 'col-lg-2 control-label']) !!}

                <div class="col-lg-6">
                    {!! Form::password('password_confirmation', ['class' => 'form-control']) !!}
                    {!! $errors->first('password_confirmation', '<span class="help-block">:message</span>') !!}
                </div>
            </div>
        @endif

        @if ($formFor == 'edit' || $formFor == 'create')
        <div class="form-group">

            {{ Form::label('status', trans("Iauth::user.inputs.seven"), ['class' => 'col-lg-2 control-label']) }}

            <div class="col-lg-1">
                @if ($formFor == 'create')
                    {{ Form::checkbox('status', '1', true) }}
                @elseif ($formFor == 'edit')
                    {{ Form::checkbox('status', '1', $user->status == 1) }}
                @endif
            </div><!--col-lg-1-->
        </div><!--form control-->

        <div class="form-group">

            {{ Form::label('is_valid_email', trans("Iauth::user.inputs.eight"), ['class' => 'col-lg-2 control-label']) }}

            <div class="col-lg-1">
                @if ($formFor == 'create')
                    {{ Form::checkbox('is_valid_email', '1', true) }}
                @elseif ($formFor == 'edit')
                    {{ Form::checkbox('is_valid_email', '1', $user->is_valid_email == 1) }}
                @endif

            </div><!--col-lg-1-->
        </div><!--form control-->

        <div class="form-group">

            {!! Form::label('roles', trans("Iauth::user.inputs.nine"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                @if (count($roles) > 0)
                    @foreach($roles as $role)
                        <input type="checkbox" value="{{ $role->id }}" name="assignees_roles[]" @if ($formFor == 'edit') {{in_array($role->id, $user_roles) ? 'checked' : ''}} @endif id="role-{{ $role->id }}" /> <label for="role-{{ $role->id }}">{{ $role->name }}</label>
                        <br/>
                    @endforeach
                @else
                    No Roles
                @endif
            </div>
        </div>
        @endif
        @if ($formFor == 'editProfile')
            <input type="hidden" name="status" value="1">
            <input type="hidden" name="is_valid_email" value="1">
        @endif
        <div class="form-group">

            {{ Form::label('image', trans("Iauth::user.inputs.ten"), ['class' => 'col-lg-2 control-label']) }}

            <div class="col-lg-6">
                <div class="input-group image-preview">
                    <input type="text" class="form-control image-preview-filename" disabled="disabled">
                    <span class="input-group-btn">
                    <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                        <span class="fa fa-remove"></span>
                        Clear
                    </button>
                    <div class="btn btn-primary image-preview-input">
                        <span class="fa fa-repeat"></span>
                        <span class="image-preview-input-title">
                            File Browse
                        </span>
                        {!! Form::file('image', null, ['class' => 'file']) !!}
                    </div>
                </span>
                </div>
                {!! $errors->first('image', '<span class="help-block">:message</span>') !!}
            </div>
        </div><!--form control-->

    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    @if($formFor == 'editProfile')
                        {{ link_to_route('profile', trans('Iauth::user.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    @else
                        {{ link_to_route('user.list', trans('Iauth::user.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    @endif
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>

            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}
@push('footerAssetPush')
<script type="application/javascript">
    $(document).on('click', '#close-preview', function(){
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
                function () {
                    $('.image-preview').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.image-preview').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'right'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });

</script>
@endpush