@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-user"></i> {{ trans('Iauth::user.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Iauth::user.breadcrumb.passwordchange') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('user.list') }}"><i class="fa fa-user"></i>{{ trans('Iauth::user.breadcrumb.passwordchange') }}</a></li>
    <li class="active">{{ trans('Iauth::user.breadcrumb.passwordchange') }}</li>
@endsection

@section('moduleContent')
        {{ Form::open(['route' => ['user.update-profile-password.post'], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'post']) }}

        <div class="box box-success">
            <div class="box-header with-border">
                <section class="content-header">
                    <h1 class="box-title">
                        @yield('moduleTitle', 'New Monule')
                        <small>@yield('moduleDescription', 'Optional description')</small>
                    </h1>
                    <ol class="breadcrumb">
                        @yield('moduleBreadcrumb', '
                             <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                             <li class="active">Here</li>
                        ')
                    </ol>
                </section>
            </div><!-- /.box-header -->

            <div class="box-body">
                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }} has-feedback">
                    {!! Form::label('password', 'Password', ['class' => 'col-lg-2 control-label']) !!}
                    <div class="col-lg-6">
                        {!! Form::password('password', ['class' => 'form-control']) !!}
                        {!! $errors->first('password', '<span class="help-block">:message</span>') !!}
                    </div>
                </div>

                <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }} has-feedback">
                    {!! Form::label('password_confirmation', 'Retype Password', ['class' => 'col-lg-2 control-label']) !!}
                    <div class="col-lg-6">
                        {!! Form::password('password_confirmation', ['class' => 'form-control']) !!}
                        {!! $errors->first('password_confirmation', '<span class="help-block">:message</span>') !!}
                    </div>
                </div>
            </div><!-- /.box-body -->
            <div class="box box-info">
                <div class="box-body">
                    <div class="form-group">
                        <div class="col-sm-4 col-sm-offset-2">
                            {{ link_to_route('user.list', trans('Iauth::user.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                            {{ Form::submit(trans('Iauth::user.buttons.update', ['name' => 'Password']), ['class' => 'btn btn-primary hidden-xs']) }}
                            {{ Form::submit(trans('Iauth::user.buttons.update', ['name' => 'Password']), ['class' => 'btn btn-primary visible-xs pull-right']) }}
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div><!-- /.box-body -->
            </div><!--box-->
        </div><!--box-->
        {{ Form::close() }}

@endsection
