@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-user"></i> {{ trans('Iauth::user.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Iauth::user.optional_title.create') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('user.list') }}"><i class="fa fa-user"></i>{{ trans('Iauth::user.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Iauth::user.breadcrumb.create') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                @include('Iauth::user._form', ['submitButton' => trans('Iauth::user.buttons.save'), 'formFor' => 'create'])
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
