@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-user"></i> {{ trans('Iauth::user.profile-title') }}
@endsection
@section('moduleDescription')
    {{ trans('Iauth::user.optional_title.profile') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('user.list') }}"><i class="fa fa-user"></i>{{ trans('Iauth::user.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Iauth::user.breadcrumb.profile') }}</li>
@endsection

@section('moduleContent')
    {{--{{ dd($user->id) }}--}}
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                <div class="box-body">
                    {{--{{ $user->username }}<br>--}}
                    {{--{{ $user->email }}<br>--}}
                    <img class="profile-user-img img-responsive img-circle" src="{{ url(auth()->user()->img) }}" alt="User profile picture">

                    <h3 class="profile-username text-center">{{ $user->name }}</h3>

                    <p class="text-muted text-center">{{ '@'.$user->username }}</p>

                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b>{{ trans("Iauth::user.inputs.two") }}</b> <a class="pull-right">{{ $user->first_name }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>{{ trans("Iauth::user.inputs.three") }}</b> <a class="pull-right">{{ $user->last_name }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>{{ trans("Iauth::user.inputs.four") }}</b> <a class="pull-right">{{ $user->email }}</a>
                        </li>
                    </ul>

                    <a href="{{ route('profile.edit', $user->username ?: $user->id) }}" class="btn btn-primary btn-block"><b>{{ trans('Iauth::backendLinks.topbar.edit') }}</b></a>

                </div>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
