<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Invoice\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait InvoiceAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@invoice-edit')) {
            return '<a href="' . route('invoice.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Invoice::invoice.buttons.actions.edit') . '"></i></a> ';
        }

        return '';
    }

    public function getViewButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@invoice-view')) {
            return '<a href="' . route('invoice.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Invoice::invoice.buttons.actions.view') . '"></i></a> ';
        }
        return '';
    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@invoice-delete')) {
            return '<a href="' . route('invoice.destroy', $this) . '"
             data-method="delete"
             data-trans-button-cancel="Cancel"
             data-trans-button-confirm="Delete"
             data-trans-title="Are you sure?"
             class="btn btn-xs btn-danger invoice-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Invoice::invoice.buttons.actions.delete') . '"></i></a> ';
        }

        return "";
    }

    public function getStatusButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@invoice-status')) {
            if ($this->status == 0)
                return "<a id=\"status\" class=\"btn btn-success btn-xs\" href=" . route('invoice.status', $this) . " title='" . trans('Invoice::invoice.buttons.actions.status.active') . "'><i class='fa fa-play'></i></a> ";
            else
                return "<a id=\"status\" class=\"btn btn-danger btn-xs\" href=" . route('invoice.status', $this) . " title='" . trans('Invoice::invoice.buttons.actions.status.deactive') . "'><i class='fa fa-pause'></i></a> ";
        }

    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getViewButtonAttribute().
            $this->getEditButtonAttribute().
            $this->getStatusButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}