<div class="box-body">
    <div class="row">
        <div class="form-group col-lg-6 has-feedback" v-bind:class="{'has-error': errors.client_id }">
            {!! Form::label('client_id', trans('Invoice::invoice.inputs.client'), ['class' => '']) !!}
            <div class="input-group">
            <span class="input-group-addon btn" data-toggle="modal" data-target="#ClientQuickAdd"><i class="fa fa-plus"></i></span>
            <select class="form-control" name="client_id" id="client_id" v-model="form.client_id">
                <option value="" >{{ trans('Invoice::invoice.inputs.select_client') }}</option>
                @foreach($clients as $key => $client)
                    <option value="{{ $key }}"> {{ $client }} </option>
                @endforeach
            </select>
            </div>
        </div>

        <div class="form-group col-lg-3 has-feedback" v-bind:class="{'has-error': errors.currency_id }">
            {!! Form::label('currency_id', trans('Invoice::invoice.inputs.currency'), ['class' => '']) !!}
            <select class="form-control" name="currency_id" id="currency_id" v-model="form.currency_id">
                <option value="" >{{ trans('Invoice::invoice.inputs.select_currency') }}</option>
                @foreach($currencies as $key => $currency)
                    <option value="{{ $key }}"> {{ $currency }} </option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-lg-3 has-feedback" v-bind:class="{'has-error': errors.serial }">
            {!! Form::label('serial', trans('Invoice::invoice.inputs.serial'), ['class' => '']) !!}
            <div class="input-group">
                <span @click="random" class="input-group-addon btn"><i class="fa fa-random"></i></span>
                {!! Form::text('serial', null, ['class' => 'form-control', 'v-model'=>"form.serial"]) !!}
            </div>
        </div>

        <div class="form-group col-lg-6 has-feedback" v-bind:class="{'has-error': errors.tax_id }">
            {!! Form::label('tax_id', trans('Invoice::invoice.inputs.tax_id'), ['class' => '']) !!}
            <select class="form-control" name="tax_id" id="tax_id" v-model="form.tax_id" @change='sortBy'>
                <option value="">{{ trans('Invoice::invoice.inputs.select_tax') }}</option>
                @foreach($taxes as $key => $tax)
                    <option value="{{ $key }}"> {{ $tax }} </option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-lg-3 has-feedback" v-bind:class="{'has-error': errors.payment_status }">
            {!! Form::label('payment_status', trans('Invoice::invoice.inputs.payment_status'), ['class' => '']) !!}
            <select class="form-control" name="payment_status" id="payment_status" v-model="form.payment_status">
                <option value="">{{ trans('Invoice::invoice.inputs.select_payment_status') }}</option>
                <option value="paid">{{ trans('Invoice::invoice.inputs.paid') }}</option>
                <option value="pending">{{ trans('Invoice::invoice.inputs.unpaid') }}</option>
                <option value="canceled">{{ trans('Invoice::invoice.inputs.canceled') }}</option>
                <option value="unknown">{{ trans('Invoice::invoice.inputs.unknown') }}</option>
                <option value="overdue">{{ trans('Invoice::invoice.inputs.overdue') }}</option>
                <option value="partially paid">{{ trans('Invoice::invoice.inputs.partially_paid') }}</option>
            </select>
        </div>

        <div class="form-group col-lg-3 has-feedback" v-bind:class="{'has-error': errors.paymenttype_id }">
            {!! Form::label('paymenttype_id', trans('Invoice::invoice.inputs.payment_type'), ['class' => '']) !!}

            <select class="form-control" name="paymenttype_id" id="paymenttype_id" v-model="form.paymenttype_id">
                <option value="">{{ trans('Invoice::invoice.inputs.select_payment_type') }}</option>
                @foreach($payment_types as $key => $type)
                    <option value="{{ $key }}"> {{ $type }} </option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-lg-3 has-feedback" v-bind:class="{'has-error': errors.create_date }">
            {!! Form::label('create_date', trans('Invoice::invoice.inputs.create_date'), ['class' => '']) !!}
            {!! Form::text('create_date', date('Y-m-d'), ['class' => 'form-control', 'v-model'=>"form.create_date"]) !!}
        </div>

        <div class="form-group col-lg-3 has-feedback" v-bind:class="{'has-error': errors.due_date }">
            {!! Form::label('due_date', trans('Invoice::invoice.inputs.due_date'), ['class' => '']) !!}
            {!! Form::text('due_date', date('Y-m-d'), ['class' => 'form-control', 'v-model'=>"form.due_date"]) !!}
        </div>

        <div class="form-group col-lg-6 has-feedback" v-bind:class="{'has-error': errors.discount }">
            {!! Form::label('discount', trans('Invoice::invoice.inputs.discount'), ['class' => '']) !!}
            {!! Form::text('discount', null, ['class' => 'form-control', 'v-model'=>"form.discount"]) !!}
        </div>

        <div class="form-group col-lg-6 has-feedback" v-bind:class="{'has-error': errors.note }">
            {!! Form::label('note', trans('Invoice::invoice.inputs.note'), ['class' => '']) !!}
            <textarea name="note" id="note" cols="30" class="form-control" rows="5" v-model='form.note'></textarea>
        </div>

        <div class="form-group col-lg-6 has-feedback" v-bind:class="{'has-error': errors.terms_conditions }">
            {!! Form::label('terms_conditions', trans('Invoice::invoice.inputs.terms_conditions'), ['class' => '']) !!}
            <textarea name="terms_conditions" id="terms_conditions" class='form-control' cols="30" rows="5" v-model='form.terms_conditions'></textarea>
        </div>
    </div>
    <div v-if="errors.products_empty">
        <p class="alert alert-danger">@{{errors.products_empty[0]}}</p>
        <hr>
    </div>
    <div class="row">
        <div class="form-group col-lg-6 has-feedback">
            {!! Form::label('product_id', trans('Invoice::invoice.inputs.item_add'), ['class' => '']) !!}
            <select class="form-control" name="product_id" id="product_id" @change='addItem'>
                <option value="">{{ trans('Invoice::invoice.inputs.select_product') }}</option>
                @foreach($products as $key => $product)
                    <option id="{{ $product }}" value="{{ $key }}"> {{ $product }} </option>
                @endforeach
            </select>
        </div>
    </div>
    <table class="table table-bordered table-form">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ trans('Invoice::invoice.table.name') }}</th>
                <th>{{ trans('Invoice::invoice.table.amount') }} ($)</th>
                <th>{{ trans('Invoice::invoice.table.quantity') }} (1)</th>
                <th>{{ trans('Invoice::invoice.table.subtotal') }} ($)</th>
            </tr>
        </thead>
        <tbody>
            <tr v-for="product in form.products">
                <td class="table-remove">
                    <button class="btn btn-danger" @click="remove(product)"><i class="fa fa-trash"></i></button>
                </td>
                <td class="table-name" :class="{'table-error': errors['products.' + $index + '.name']}">
                    <input class="form-control" v-model="product.name">
                </td>
                <td class="table-price" :class="{'table-error': errors['products.' + $index + '.price']}">
                    <input type="text" class="form-control"  v-model="product.price" placeholder="0.00">
                </td>
                <td class="table-quantity" :class="{'table-error': errors['products.' + $index + '.quantity']}">
                    <input type="text" class="form-control" v-model="product.quantity">
                </td>
                <td class="table-total">
                    <span class="table-text">@{{product.quantity * product.price}}</span>
                </td>
            </tr>
        </tbody>
        <tfoot>
        <tr>
            <td class="table-empty" colspan="3">
                <button @click="addLine" class="btn btn-primary table-add_line"><i class="fa fa-plus"></i></button>
                <button @click="removeAll()" class="btn btn-danger" ><i class="fa fa-refresh"></i></button>
            </td>
            <td class="table-label">{{ trans('Invoice::invoice.table.subtotal') }}</td>
            <td class="table-amount">@{{subTotal}}</td>
        </tr>
        <tr>
            <td class="table-empty" colspan="3"></td>
            <td class="table-label">{{ trans('Invoice::invoice.table.discount') }}</td>
            <td class="table-discount" :class="{'table-error': errors.discount}">
                <input type="text" class="form-control table-discount_input" v-model="form.discount" placeholder="0.00">
            </td>
        </tr>
        <tr>
            <td class="table-empty" colspan="3"></td>
            <td class="table-label">{{ trans('Invoice::invoice.table.tax') }}</td>
            <td class="table-tax">@{{totalTax}}</td>
        </tr>
        <tr>
            <td class="table-empty" colspan="3"></td>
            <td class="table-label">{{ trans('Invoice::invoice.table.grand_total') }}</td>
            <td class="table-amount">@{{grandTotal}}</td>
        </tr>
        </tfoot>
    </table>
</div>

<!-- Client Quick Add -->
<div class="modal fade" id="ClientQuickAdd" role="dialog">
    <div class="modal-dialog ">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">{{ trans('Client::client.optional_title.create') }}</h4>
            </div>
            {!! Form::open(['method' => 'POST','route' => ['client.create.post'], 'id' => 'ClientFrom', 'class' => 'form-horizontal', 'enctype' => 'multipart/form-data']) !!}
            <div class="modal-body">

                <div class="form-group{{ $errors->has('username') ? ' has-error' : '' }}">

                    {!! Form::label('username', trans("Iauth::user.inputs.one"), ['class' => 'col-lg-4 control-label']) !!}

                    <div class="col-lg-8">
                        {!! Form::text('username', null, ['class' => 'form-control', 'required' => 'required']) !!}
                        <span class="text-danger" id="error_username"></span>
                    </div>
                </div>

                <div class="form-group{{ $errors->has('first_name') ? ' has-error' : '' }}">

                    {!! Form::label('first_name',  trans("Iauth::user.inputs.two"), ['class' => 'col-lg-4 control-label']) !!}

                    <div class="col-lg-8">
                        {!! Form::text('first_name', null, ['class' => 'form-control']) !!}
                        <span class="text-danger" id="error_first_name"></span>
                    </div>
                </div>

                <div class="form-group{{ $errors->has('last_name') ? ' has-error' : '' }}">

                    {!! Form::label('last_name',  trans("Iauth::user.inputs.three"), ['class' => 'col-lg-4 control-label']) !!}

                    <div class="col-lg-8">
                        {!! Form::text('last_name', null, ['class' => 'form-control']) !!}
                        <span class="text-danger" id="error_last_name"></span>
                    </div>
                </div>

                <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">

                    {!! Form::label('email',  trans("Iauth::user.inputs.four"), ['class' => 'col-lg-4 control-label']) !!}

                    <div class="col-lg-8">
                        {!! Form::text('email', null, ['class' => 'form-control', 'required' => 'required']) !!}
                        <span class="text-danger" id="error_email"></span>
                    </div>
                </div>

                <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
                    {!! Form::label('company', trans("Client::client.inputs.company"), ['class' => 'col-lg-4 control-label']) !!}
                    <div class="col-lg-8">
                        {!! Form::text('company', null, ['class' => 'form-control', 'required' => 'required']) !!}
                        <span class="text-danger" id="error_company"></span>
                    </div>
                </div>

                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">

                        {!! Form::label('password',  trans("Iauth::user.inputs.five"), ['class' => 'col-lg-4 control-label']) !!}

                        <div class="col-lg-8">
                            {!! Form::password('password', ['class' => 'form-control']) !!}
                            <span class="text-danger" id="error_password"></span>
                        </div>
                </div>

                <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">

                    {!! Form::label('password_confirmation', trans("Iauth::user.inputs.six"), ['class' => 'col-lg-4 control-label']) !!}

                    <div class="col-lg-8">
                        {!! Form::password('password_confirmation', ['class' => 'form-control']) !!}
                        <span class="text-danger" id="error_password_confirmation"></span>
                    </div>
                </div>

                <div class="form-group">

                    {{ Form::label('image', trans("Iauth::user.inputs.ten"), ['class' => 'col-lg-4 control-label']) }}

                    <div class="col-lg-8">
                        <div class="input-group image-preview">
                            <input type="text" class="form-control image-preview-filename" disabled="disabled">
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                                    <span class="fa fa-remove"></span>
                                    Clear
                                </button>
                                <div class="btn btn-primary image-preview-input">
                                    <span class="fa fa-repeat"></span>
                                    <span class="image-preview-input-title">
                                        File Browse
                                    </span>
                                    {!! Form::file('image', null, ['class' => 'file']) !!}
                                </div>
                            </span>
                        </div>
                        <span class="text-danger" id="error_image"></span>
                    </div>
                </div><!--form control-->

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-success" id="send-email">{{ trans('Client::client.buttons.create') }}</button>
            </div>
            {!!  Form::close()  !!}
        </div>

    </div>
</div>
<!-- /.payment history -modal -->
@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/datepicker/datepicker3.css') }}">
<style type="text/css">
    .select2-container .select2-selection--single {
        height: 34px !important;
    }
    .select2-container--default .select2-selection--single {
        border-radius: 0px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 34px !important;
    }
    .error {
        color: #a94442;
        margin: 0;
    }

    .table-error > textarea,
    .table-error > input {
        background: #f2dede;
    }
</style>
@endpush

@push('footerAssetPush')
<script src="{{ url('bassets/plugins/select2/select2.full.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
<script src="{{ url('bassets/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script>
    $('.select2').select2();
    $('#due_date').datepicker({format: 'yyyy-mm-dd', autoclose: true});
    $('#create_date').datepicker({format: 'yyyy-mm-dd', autoclose: true});
    $('#paid_date').datepicker({format: 'yyyy-mm-dd', autoclose: true});

    function  invoiceRand () {
        var random = "{{ rand() }}";
        $(this).val(random);
    }

    $(document).on('click', '#close-preview', function(){
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
                function () {
                    $('.image-preview').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.image-preview').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'bottom'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });


    $("#ClientFrom").submit(function (e) {
        var inputData = new FormData($(this)[0]);

        e.preventDefault();

        $.ajax({
            type : "POST",
            url : '{{ route("client.create.post") }}',
            dataType : "JSON",
            data:inputData,
            contentType: false,
            processData: false,
            async: false,
            success : function(response) {
                console.log(response);
                location.reload();
            }, error: function(data){
                // Error...
                var errors = $.parseJSON(data.responseText);

                $.each(errors, function(index, value) {
                    console.log(index);
                    console.log(value);
                    $("#error_"+index).html(value);
                });
            }
        });
        return false;
    });
</script>
@endpush