<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Type" content="text/html">
    <meta name="_token" content="{{csrf_token()}}">
    <link href="{{ url(get_isite_favicon()) }}" rel="shortcut icon">
    <title>{{ strip_tags(get_isite_sitename()) }}</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <style type="text/css">
        #page-wrap {
            width: 700px;
            margin: 0 auto;
            padding-top: 50px;
        }
        .center-justified {
            text-align: justify;
            margin: 0 auto;
            width: 30em;
        }
        /*ini starts here*/
        .list-group {
            padding-left: 0;
            margin-bottom: 15px;
            width: auto;
        }
        .list-group-item {
            position: relative;
            display: block;
            padding: 7.5px 10px;
            margin-bottom: -1px;
            background-color: #fff;
            border: 1px solid #ddd;
            /*margin: 2px;*/
        }
        table {
            border-spacing: 0;
            border-collapse: collapse;
            font-size: 12px;
        }
        td,
        th {
            padding: 0;
        }
        @media print {
            * {
                color: #000 !important;
                text-shadow: none !important;
                background: transparent !important;
                box-shadow: none !important;
            }
            a,
            a:visited {
                text-decoration: underline;
            }
            a[href]:after {
                content: " (" attr(href) ")";
            }
            abbr[title]:after {
                content: " (" attr(title) ")";
            }
            a[href^="javascript:"]:after,
            a[href^="#"]:after {
                content: "";
            }
            pre,
            blockquote {
                border: 1px solid #999;

                page-break-inside: avoid;
            }
            thead {
                display: table-header-group;
            }
            tr,
            img {
                page-break-inside: avoid;
            }
            img {
                max-width: 100% !important;
            }
            p,
            h2,
            h3 {
                orphans: 3;
                widows: 3;
            }
            h2,
            h3 {
                page-break-after: avoid;
            }
            select {
                background: #fff !important;
            }
            .navbar {
                display: none;
            }
            .table td,
            .table th {
                background-color: #fff !important;
            }
            .btn > .caret,
            .dropup > .btn > .caret {
                border-top-color: #000 !important;
            }
            .label {
                border: 1px solid #000;
            }
            .table {
                border-collapse: collapse !important;
            }
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #ddd !important;
            }
        }
        table {
            max-width: 100%;
            background-color: transparent;
            font-size: 12px;
        }
        th {
            text-align: left;
        }
        .table {
            width: 100%;
            margin-bottom: 10px;
        }
        .head {
            border-top: 0px solid #e2e7eb;
            border-bottom: 0px solid #e2e7eb;
        }
        .table > thead > tr > th,
        .table > tbody > tr > th,
        .table > tfoot > tr > th,
        .table > thead > tr > td,
        .table > tbody > tr > td,
        .table > tfoot > tr > td {
            padding: 5px;
            line-height: 1.428571429;
            vertical-align: top;
            border-top: 1px solid #e2e7eb;
        }
        /*ini edit default value : border top 1px to 0 px*/
        .table > thead > tr > th {
            font-size: 12px;
            font-weight: 500;
            vertical-align: bottom;
            color: #242a30;
        }

        .table > caption + thead > tr:first-child > th,
        .table > colgroup + thead > tr:first-child > th,
        .table > thead:first-child > tr:first-child > th,
        .table > caption + thead > tr:first-child > td,
        .table > colgroup + thead > tr:first-child > td,
        .table > thead:first-child > tr:first-child > td {
            border-top: 0;
        }
        .table > tbody + tbody {
            border-top: 2px solid #e2e7eb;
        }
        .table .table {
            background-color: #fff;
        }
        .table-condensed > thead > tr > th,
        .table-condensed > tbody > tr > th,
        .table-condensed > tfoot > tr > th,
        .table-condensed > thead > tr > td,
        .table-condensed > tbody > tr > td,
        .table-condensed > tfoot > tr > td {
            padding: 5px;
        }
        .table-bordered {
            border: 1px solid #e2e7eb;
        }
        .table-bordered > thead > tr > th,
        .table-bordered > tbody > tr > th,
        .table-bordered > tfoot > tr > th,
        .table-bordered > thead > tr > td,
        .table-bordered > tbody > tr > td,
        .table-bordered > tfoot > tr > td {
            border: 1px solid #e2e7eb;
        }
        .table-bordered > thead > tr > th,
        .table-bordered > thead > tr > td {
            border-bottom-width: 2px;
        }
        .table-striped > tbody > tr:nth-child(odd) > td,
        .table-striped > tbody > tr:nth-child(odd) > th {
            background-color: #f0f3f5;
        }
        .panel-title {
            margin-top: 0;
            margin-bottom: 0;
            font-size: 16px;
            color: #fff;
            padding: 0;
        }
        .panel-title > a {
            color: #707478;
            text-decoration: none;
        }
        a {
            background: transparent;
            color: #707478;
            text-decoration: none;
        }
        strong {
            color: #707478;
        }

        .total {
            float: left;
            color: #232A3F;
            margin-left: 80px;
            font-weight: 200;
        }

        .lead {
            font-size: 16px;
        }
        address {
            font-size: 14px;
        }

        .btn-primary {
            background-color: #364760;
            border-color: #364760;
        }
        .btn {
            border: 1px solid transparent;
            border-radius: 3px;
            box-shadow: none;
        }
        .pull-right {
            float: right;
        }
        .btn {
            -moz-user-select: none;
            background-image: none;
            border: 1px solid transparent;
            border-radius: 4px;
            cursor: pointer;
            display: inline-block;
            font-size: 14px;
            font-weight: 400;
            line-height: 1.42857;
            margin-bottom: 0;
            padding: 6px 12px;
            text-align: center;
            vertical-align: middle;
            white-space: nowrap;
        }
    </style>
</head>
<body>

<div id="page-wrap">
    <table width="100%">
        <tr>
            <td width="5%">
                {{--{{ get_logo() }}--}}
                @if(get_logo() != null)<img src="{{ url(get_logo()) }}" height="50px" class="pull-left thumb-xs m-r-sm">@endif
            </td>
        </tr>
        <tr style="padding: 0;margin: 0;">
            <td width="75%" >
                <h2 style="font-weight: 200">
                    {!! isite()->siteName()."<br>". isite()->sitePhone()."<br>".isite()->siteAddress()."<br>".isite()->siteCity().', '.isite()->siteState().', '.isite()->siteCountry()."<br>".isite()->siteEmail() !!}
                </h2>
            </td>
            <td width="25%">
                <h2 style="font-weight: 200">{!! strtoupper(trans("Invoice::invoice.module"))."<br>"."<b>#".$invoice->serial."</b>" !!} </h2>
            </td>
        </tr>
    </table>
    <hr>
    <table width="100%">
        <tr>
            <td width="50%">
                <h2>{{ trans('Invoice::invoice.view.to') }}</h2>
                <address>
                    <strong>{{ $client->name }}</strong><br>
                    @if(isset($company->company)){{ $company->company }}<br>@endif
                    @if($company->phone){{ $company->phone }}<br>@endif
                    {{ $company->address_line_one. ', '. $company->address_line_two }}<br>
                    {{ $company->city. ', '. $company->state.', '.$company->zip_code.', '.$company->country }}<br>
                    {{ trans('Invoice::invoice.view.email') }}: {{ $client->email }}
                </address>
            </td>
            <td width="50%">
                <h2>{{ trans('Invoice::invoice.view.info') }}</h2>
                <table class="table table-striped table-bordered" width="100%">
                    <tbody>
                    <tr>
                        <th>INVOICE</th>
                        <td>#{{ $invoice->serial }}</td>
                    </tr>
                    <tr>
                        <th><b>ORDER ID</b></th>
                        <td>#{{ $invoice->id }}</td>
                    </tr>
                    <tr>
                        <th><b>PAYMENT TYPE:</b></th>
                        <td>#{{ $invoice->paymenttype->name }}</td>
                    </tr>
                    <tr>
                        <th><b>DUE DATE:</b></th>
                        <td>#{{ Carbon\Carbon::parse($invoice->due_date)->format('jS F Y ') }}</td>
                    </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </table>
    <br /><br />

    <table class="table table-striped table-bordered">
        <thead>
        <tr>
            <th data-title="{{ trans('Invoice::invoice.table.name') }}">{{ trans('Invoice::invoice.table.name') }}</th>
            <th data-title="{{ trans('Invoice::invoice.table.amount') }}">{{ trans('Invoice::invoice.table.amount') }}</th>
            <th data-title="{{ trans('Invoice::invoice.table.quantity') }}">{{ trans('Invoice::invoice.table.quantity') }}</th>
            <th data-title="{{ trans('Invoice::invoice.table.subtotal') }}">{{ trans('Invoice::invoice.table.subtotal') }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach($invoice->products as $product)
            <tr>
                <td data-title="{{ trans('Invoice::invoice.table.name') }}" class="table-name">{{$product->name}}</td>
                <td  data-title="{{ trans('Invoice::invoice.table.amount') }}" class="table-price">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->price, 2)}}</td>
                <td  data-title="{{ trans('Invoice::invoice.table.quantity') }}" class="table-qty">{{$product->quantity}}</td>
                <td data-title="{{ trans('Invoice::invoice.table.subtotal') }}" class="table-total text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->quantity * $product->price, 2)}}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <table width="100%">
        <tbody>
            <tr>
                <td width="40%">
                    @if($invoice->payment_status=="paid")
                        <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/paid.png') }}" alt="paid" width="250" height="150" >
                    @elseif($invoice->payment_status=="unpaid")
                        <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/unpaid.png') }}" alt="unpaid" width="250" height="150" >
                    @elseif($invoice->payment_status=="canceled")
                        <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/canceled.png') }}" alt="canceled" width="250" height="150" >
                    @elseif($invoice->payment_status=="partially paid")
                        <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/due.png') }}" alt="paid" width="250" height="150" >
                    @elseif($invoice->payment_status=="pending")
                        <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/due.png') }}" alt="paid" width="250" height="150" >
                    @endif
                </td>
                <td width="60%" style="float: right;">
                    <table class="table table-bordered">
                        <tfoot>
                        <tr>
                            <th class="table-label">Sub Total</th>
                            <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->sub_total, 2)}}</td>
                        </tr>
                        <tr>
                            <th class="table-label">Discount</th>
                            <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->discount, 2)}}</td>
                        </tr>
                        <tr>
                            <th class="table-label">Tax</th>
                            <td class="table-amount text-right">
                                @if(isset($tax))
                                    @if($tax->type == 1)
                                        %
                                    @else
                                        {{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}
                                    @endif
                                    {{$tax->rate}}
                                @else
                                    0.00
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th class="table-label">Paid Amount</th>
                            <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->payments->sum('paid_amount'),2)}}</td>
                        </tr>
                        <tr>
                            <th class="table-label">Due Amount</th>
                            <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->grand_total - $invoice->payments->sum('paid_amount'), 2)}}</td>
                        </tr>
                        <tr>
                            <th class="table-label">Grand Total</th>
                            <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->grand_total, 2) }}</td>
                        </tr>
                        </tfoot>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
    <table>
        <tr>
            <td>
                <b>{{ trans("Invoice::invoice.inputs.note") }}:</b>
                <p class="text-muted well well-sm no-shadow">
                    {{ $invoice->note }}
                </p>
            </td>
        </tr>
        <tr>
            <td width="100%">
                <b>{{ trans("Invoice::invoice.inputs.terms_conditions") }}:</b>
                <p class="text-muted well well-sm no-shadow" style="">
                    {{ $invoice->terms_conditions }}
                </p>
            </td>
        </tr>
    </table>
    <br>

    <table width="100%">
        <a class="btn btn-primary pull-right" style="margin-right: 5px;" href="{{ route('invoice.global.pdf', [$invoice->serial,$invoice->token]) }}">
            <i class="fa fa-download"></i> {{ trans('Invoice::invoice.buttons.generate_pdf') }}
        </a>
    </table>
</div>



</body>
</html>