@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Invoice::invoice.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Invoice::invoice.optional_title.edit') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('invoice.list') }}"><i class="fa fa-laptop"></i>{{ trans('Invoice::invoice.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Invoice::invoice.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                {{--@include('Invoice::_form', ['submitButton' => trans('Invoice::invoice.buttons.add'), 'formFor' => 'create'])--}}
                <div id="invoice">
                    <div v-cloak>
                        <a class="hidden" id="route" href="{{route('invoice.edit', $invoice)}}" ></a>
                        <a class="hidden" id="taxRate" href="{{route('invoice.get_tax', null)}}" ></a>
                        @include('Invoice::_form')
                        <div class="box-footer">
                            <a href="{{route('invoice.list')}}" class="btn btn-default">{{ trans('Invoice::invoice.buttons.cancel') }}</a>
                            <button class="btn btn-success" @click="update('save')" :disabled="isProcessing">{{ trans('Invoice::invoice.buttons.update') }}</button>
                            <button class="btn btn-success" @click="update('send')" :disabled="isProcessing">{{ trans('Invoice::invoice.buttons.create_send') }}</button>
                        </div>
                    </div>
                </div>
                {{-- Invoice form end --}}
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection

@push('footerAssetPush')
<script src="{{ url('public/assets/invoice/js/vue.min.js') }}"></script>
<script src="{{ url('public/assets/invoice/js/vue-resource.min.js') }}"></script>
<script type="text/javascript">
    Vue.http.headers.common['X-CSRF-TOKEN'] = '{{csrf_token()}}';

    window._form = {!! $invoice->toJson() !!};
</script>
<script src="{{ url('public/assets/invoice/js/app.js') }}"></script>
@endpush