@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Invoice::invoice.paymentTitle') }}
@endsection
@section('moduleDescription')
    {{ trans('Invoice::invoice.optional_title.paymentList') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('payment.list') }}"><i class="fa fa-laptop"></i>{{ trans('Invoice::invoice.breadcrumb.first_payment') }}</a></li>
    <li class="active">{{ trans('Invoice::invoice.breadcrumb.second_payment') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <table id="payments-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}#</th>
                            <th>{{ trans('Invoice::invoice.columns.payment_by') }}</th>
                            <th>{{ trans('Invoice::invoice.columns.payment_type') }}</th>
                            <th>{{ trans('Invoice::invoice.columns.transaction_id') }}</th>
                            <th>{{ trans('Invoice::invoice.columns.currency') }}</th>
                            <th>{{ trans('Invoice::invoice.columns.payment_date') }}</th>
                            <th>{{ trans('Invoice::invoice.columns.paid_amount') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#payments-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("payments.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'serial', name: 'serial'},
                {data: 'user', name: 'user'},
                {data: 'payment_type', name: 'payment_type'},
                {data: 'transaction_id', name: 'transaction_id'},
                {data: 'currency_code', name: 'currency_code'},
                {data: 'paid_date', name: 'paid_date'},
                {data: 'paid_amount', name: 'paid_amount'}
            ],
            order: [[0, "asc"]],
            searchDelay: 500

        });
    });
</script>
@endpush