<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Lang\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Stichoza\GoogleTranslate\TranslateClient;
use File, Alert;

class LangController extends Controller
{
    protected $translator;

    protected $langPath = [
        'Core',
        'Modules',
        'resources'
    ];

    function __construct()
    {
        $this->translator = new TranslateClient();
    }

    public function index()
    {
        return view('Lang::index');
    }

    public function convert(Request $request)
    {
        if(config('core.demosite')) {
            Alert::warning('Disabled', trans('Core::demo.message'));
            return redirect()->route('lang.convert.post');
        }

        foreach ($this->langPath as $namespace) {
            if($namespace == 'Core') {
                $langIdentity   = base_path($namespace.'/src/Lang/');
                if($langIdentity) {
                    $this->translateFile($request['source'], $request['destination'], $langIdentity, $namespace);
                }
            } elseif($namespace == 'Modules') {
                if(is_dir(base_path('Modules'))) {

                    $modules = $this->getAllActiveModules();

                    foreach ($modules as $module) {
                        $langIdentity   = base_path($namespace.'/'.$module.'/Lang/');
                        if(is_dir($langIdentity)) {
                            $this->translateFile($request['source'], $request['destination'], $langIdentity, $module);
                        }
                    }
                }
            } elseif($namespace == 'resources') {
                $langIdentity   = base_path($namespace.'/lang/');
                if($langIdentity) {
                    $this->translateFile($request['source'], $request['destination'], $langIdentity);
                }
            }
        }
        Alert::success('Lang successfully Converted!', 'success');
        return redirect(route('lang'));
    }

    public function getAllActiveModules()
    {
        $getAllModules = array_map('class_basename', File::directories(base_path('Modules')));
        $disableModules = config("module.disable");

        $modules = array_diff($getAllModules, $disableModules);

        return $modules;
    }

    public function translateFile($source, $destination, $translateRootPath , $namespace = null)
    {
        $allLang         = glob($translateRootPath.'/'.$source.'/*.php');
        $destinationPath = $translateRootPath.'/'.$destination;

        if(! is_dir($destinationPath)) {
            File::makeDirectory($destinationPath);
        }

        if($namespace != null) {
            $namespace .= '::';
        }

        foreach ($allLang as $singleLang) {
            $fileName = basename($singleLang, '.php');
            $langs = trans($namespace.''.$fileName);
            $translate = file_get_contents($singleLang);

            array_walk_recursive($langs, function($item, $key) use (&$translate, $source, $destination) {
                $searchString = "'" . $item . "'";
                $replaceString = "'" . $this->manupulateTranslateString($item, $source, $destination) . "'";
                $translate = str_replace($searchString, $replaceString, $translate);
            });

            $translateFileName = $destinationPath.'/'.$fileName.'.php';
            File::put($translateFileName, $translate);
        }
    }

    public function manupulateTranslateString($string, $source, $destination)
    {
        $splitArray = explode(" ", $string);

        $sentence = "";
        $translateSentence = "";
        foreach($splitArray as $s) {
            if(!empty($s) && $s[0] != ':') {
                $sentence .= $s." ";
            } else {
                if($sentence != "" && $sentence != " ") {
                    $sentence = $this->translator->setSource($source)->setTarget($destination)->translate($sentence);
                    $translateSentence .= $sentence." ".$s." ";
                } else {
                    $translateSentence .= $s." ";
                }

                $sentence = "";
            }
        }
        if($translateSentence == "")
            $translateSentence = $this->translator->setSource($source)->setTarget($destination)->translate($sentence);
        elseif($sentence != "") {
            if($sentence[0] != ":" && $sentence != " ") {
                $translateSentence .= $this->translator->setSource($source)->setTarget($destination)->translate($sentence);
            } else {
                $translateSentence .= $sentence;
            }
        }

        return str_replace("'", "\\'", $translateSentence);
    }

}
